/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.HashMap;
import java.util.Map;

public enum WsTrustTokenType {
    SAML20("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"),
    SAML11("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"),
    SAML11O365("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1O365"),
    X509("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3"),
    BINARY("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary"),
    USERNAME("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken"),
    JWT("urn:ietf:params:oauth:token-type:jwt"),
    STRING("urn:pingidentity.com:token-type:string");

    private static Map<String, WsTrustTokenType> uri2Type;
    private String uri;

    private WsTrustTokenType(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public static WsTrustTokenType fromUri(String uri) {
        return uri2Type.get(uri);
    }

    static {
        uri2Type = new HashMap<String, WsTrustTokenType>();
        uri2Type.put(SAML20.getUri(), SAML20);
        uri2Type.put(SAML11.getUri(), SAML11);
        uri2Type.put(SAML11O365.getUri(), SAML11O365);
        uri2Type.put(X509.getUri(), X509);
        uri2Type.put(BINARY.getUri(), BINARY);
        uri2Type.put(USERNAME.getUri(), USERNAME);
        uri2Type.put(JWT.getUri(), JWT);
        uri2Type.put(STRING.getUri(), STRING);
    }
}

