/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model.mapper;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectWalker;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.protocol.dsig10.xml.ReferenceType;
import org.sourceid.protocol.dsig10.xml.SignatureType;
import org.sourceid.protocol.dsig10.xml.SignedInfoType;
import org.sourceid.wstrust.model.Signature;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.mapper.XmlLocalName;

public class SignatureVisitCallback
implements XmlObjectWalker.VisitCallback {
    public static final QName BIND_NAME = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    private SoapHeaders headers;

    public SignatureVisitCallback(SoapHeaders headers) {
        this.headers = headers;
    }

    @Override
    public void visit(XmlObject xml, QName qName) {
        final Signature sig = new Signature(xml);
        this.headers.setSignature(sig);
        SignatureType signatureType = (SignatureType)xml;
        KeyInfoType info = signatureType.getKeyInfo();
        XmlObjectWalker walker = new XmlObjectWalker((XmlObject)info);
        walker.addCallback(new XmlObjectWalker.VisitCallback(){

            @Override
            public void visit(XmlObject xmlObject, QName qName) {
                XmlLocalName lName = XmlLocalName.fromLocalName(qName.getLocalPart());
                if (lName != null) {
                    switch (lName) {
                        case REFERENCE: {
                            XmlCursor cur = xmlObject.newCursor();
                            sig.setTokenId(SignatureVisitCallback.this.attr(cur, "URI"));
                            sig.setValueType(SignatureVisitCallback.this.attr(cur, "ValueType"));
                            XmlBeansUtil.disposeCursor(cur);
                            break;
                        }
                    }
                }
            }
        });
        walker.walkEveryNode();
        SignedInfoType signedInfo = signatureType.getSignedInfo();
        for (ReferenceType referenceType : signedInfo.getReferenceArray()) {
            String uri = referenceType.getURI();
            sig.addReferencedId(uri.startsWith("#") ? uri.substring(1) : uri);
        }
    }

    private String attr(XmlCursor cur, String name) {
        return cur.getAttributeText(new QName(null, name));
    }
}

