/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model.mapper;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectWalker;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.UsernameToken;
import org.sourceid.wstrust.model.mapper.TokenVisitCallback;
import org.sourceid.wstrust.model.mapper.XmlLocalName;

public class UsernameTokenVisitCallback
extends TokenVisitCallback {
    public static final QName USERNAME_TOKEN_NAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    private UsernameToken token;

    public UsernameTokenVisitCallback(List<SecurityToken> tokenList) {
        super(tokenList);
    }

    @Override
    public void visit(XmlObject xmlObject, QName name) {
        this.token = new UsernameToken();
        XmlObjectWalker walker2 = new XmlObjectWalker(xmlObject);
        walker2.addCallback(new XmlObjectWalker.VisitCallback(){

            @Override
            public void visit(XmlObject xmlObject, QName qName) {
                XmlLocalName localName = XmlLocalName.fromLocalName(qName.getLocalPart());
                if (localName != null) {
                    switch (localName) {
                        case USERNAME_TOKEN: {
                            XmlCursor xmlCursor = xmlObject.newCursor();
                            UsernameTokenVisitCallback.this.token.setId(xmlCursor.getAttributeText(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")));
                            XmlBeansUtil.disposeCursor(xmlCursor);
                            break;
                        }
                        case USERNAME: {
                            XmlCursor xmlCursor = xmlObject.newCursor();
                            UsernameTokenVisitCallback.this.token.setUsername(xmlCursor.getTextValue().trim());
                            XmlBeansUtil.disposeCursor(xmlCursor);
                            break;
                        }
                        case PASSWORD: {
                            XmlCursor xmlCursor = xmlObject.newCursor();
                            UsernameTokenVisitCallback.this.token.setPassword(xmlCursor.getTextValue().trim());
                            UsernameTokenVisitCallback.this.token.setPasswordType(xmlCursor.getAttributeText(new QName("Type")));
                            XmlBeansUtil.disposeCursor(xmlCursor);
                            break;
                        }
                        case NONCE: {
                            XmlCursor xmlCursor = xmlObject.newCursor();
                            UsernameTokenVisitCallback.this.token.setNonce(xmlCursor.getTextValue().trim());
                            UsernameTokenVisitCallback.this.token.setNonceEncoding(xmlCursor.getAttributeText(new QName("EncodingType")));
                            XmlBeansUtil.disposeCursor(xmlCursor);
                            break;
                        }
                    }
                }
            }
        });
        walker2.walkThisAndChildern();
        this.tokenList.add(this.token);
    }
}

