/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.processor.oauth;

import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.openid.connect.domain.ClientRegistrationCoreParameters;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.BearerAccessTokenFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.process.InvalidTokenException;
import org.sourceid.wstrust.plugin.process.TokenContext;
import org.sourceid.wstrust.plugin.process.TokenPluginDescriptor;
import org.sourceid.wstrust.plugin.process.TokenProcessor;
import org.sourceid.wstrust.plugin.process.TokenProcessorDescriptor;

public class BearerAccessTokenTokenProcessor
implements TokenProcessor<BinarySecurityToken> {
    private static final String TYPE = "urn:pingidentity.com:oauth2:grant_type:validate_bearer";
    private static final String DESCRIPTION = "OAuth Bearer Access Token Token Processor";
    private static final String FIELD_NAME_TOKEN_MANAGER = "Access Token Manager";
    private static final String FIELD_NAME_SCOPE = "Scope value as single string";
    private boolean scopeAsString = false;
    private String tokenManagerId;
    private final TokenProcessorDescriptor tokenProcessorDescriptor;
    private final BearerAccessTokenMgmtPluginManager tokenManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();

    public BearerAccessTokenTokenProcessor() {
        BearerAccessTokenFieldDescriptor tokenManagerDescriptor = new BearerAccessTokenFieldDescriptor(FIELD_NAME_TOKEN_MANAGER, "The Access Token Management plugin instance that will be used to validate the OAuth Bearer Access Token.");
        tokenManagerDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        CheckBoxFieldDescriptor scopeStringDescriptor = new CheckBoxFieldDescriptor(FIELD_NAME_SCOPE, "If selected, the Scope value will be made available as a single space delimited set of string values.  Alternatively, Scope values will be made available as a multivalue attribute.");
        GuiConfigDescriptor gui = new GuiConfigDescriptor(DESCRIPTION);
        gui.addField((FieldDescriptor)tokenManagerDescriptor);
        gui.addField((FieldDescriptor)scopeStringDescriptor);
        HashSet<String> contract = new HashSet<String>();
        contract.add(ClientRegistrationCoreParameters.EXPIRES_AT.getName());
        contract.add(Parameters.CLIENT_ID);
        contract.add(Parameters.SCOPE);
        contract.add("aud");
        contract.add("iss");
        contract.add("authorization_details");
        this.tokenProcessorDescriptor = new TokenProcessorDescriptor(DESCRIPTION, (Plugin)this, gui, TYPE, contract, "1.0");
        this.tokenProcessorDescriptor.setSupportsExtendedContract(true);
        this.tokenProcessorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public void configure(Configuration configuration) {
        this.scopeAsString = configuration.getBooleanFieldValue(FIELD_NAME_SCOPE);
        this.tokenManagerId = configuration.getFieldValue(FIELD_NAME_TOKEN_MANAGER);
        if (this.tokenManagerId == null) {
            this.tokenManagerId = "default";
        }
    }

    public TokenPluginDescriptor getPluginDescriptor() {
        return this.tokenProcessorDescriptor;
    }

    public TokenContext processToken(BinarySecurityToken token) throws InvalidTokenException, TokenProcessingException {
        String tokenValue = new String(token.getDecodedData(), StandardCharsets.UTF_8);
        AccessToken accessToken = this.tokenManager.validateAccessToken(Collections.singletonList(this.tokenManagerId), tokenValue).getAccessToken();
        AsAuditLogger.setAccessTokenTrackingId(tokenValue);
        AsAuditLogger.setInAccessTokenHash(tokenValue);
        if (accessToken == null) {
            throw new InvalidTokenException("token not found, expired or invalid");
        }
        if (accessToken.isExpired()) {
            throw new InvalidTokenException("token expired");
        }
        AttributeMap subjectAttributes = new AttributeMap();
        subjectAttributes.putAll(accessToken.getAttributes());
        subjectAttributes.put(Parameters.CLIENT_ID, accessToken.getClientId());
        subjectAttributes.put(ClientRegistrationCoreParameters.EXPIRES_AT.getName(), Long.toString(accessToken.getExpiresAt()));
        subjectAttributes.put("iss", accessToken.getIssuer());
        if (accessToken.getAudience() != null && !accessToken.getAudience().isEmpty()) {
            subjectAttributes.put("aud", new AttributeValue((Collection)accessToken.getAudience()));
        }
        if (this.scopeAsString) {
            subjectAttributes.put(Parameters.SCOPE, accessToken.getScope());
        } else {
            Scope scope = Scope.getScope((String)accessToken.getScope());
            subjectAttributes.put(Parameters.SCOPE, new AttributeValue((Collection)scope.getScopeSet()));
        }
        if (accessToken.getAuthorizationDetails() != null) {
            subjectAttributes.put("authorization_details", accessToken.getAuthorizationDetails().toAttributeValue());
        }
        TokenContext tokenContext = new TokenContext();
        tokenContext.setSubjectAttributes((Map)subjectAttributes);
        return tokenContext;
    }
}

