/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.protocol;

import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.protocol.WSTrustProtocolManager;
import org.sourceid.wstrust.protocol.WSTrustVersionInfo;
import org.sourceid.wstrust.protocol.v13.WSTrust13ProtocolManager;
import org.sourceid.wstrust.protocol.v13.WSTrust13VersionInfo;
import org.sourceid.wstrust.protocol.v2005.WSTrust2005ProtocolManager;
import org.sourceid.wstrust.protocol.v2005.WSTrust2005VersionInfo;

public enum WSTrustVersion {
    v13{

        @Override
        public WSTrustVersionInfo getDocumentNamespace() {
            return WSTrust13VersionInfo.DOCUMENT_NAMESPACE;
        }

        @Override
        public WSTrustVersionInfo getIssue() {
            return WSTrust13VersionInfo.ISSUE;
        }

        @Override
        public WSTrustVersionInfo getIssueActionRst() {
            return WSTrust13VersionInfo.ISSUE_ACTION_RST;
        }

        @Override
        public WSTrustVersionInfo getIssueActionRstr() {
            return this.getIssueActionRstrFinal();
        }

        @Override
        public WSTrustVersionInfo getIssueActionRstrFinal() {
            return WSTrust13VersionInfo.ISSUE_ACTION_RSTR_FINAL;
        }

        @Override
        public WSTrustVersionInfo getValidate() {
            return WSTrust13VersionInfo.VALIDATE;
        }

        @Override
        public WSTrustVersionInfo getValidateActionRst() {
            return WSTrust13VersionInfo.VALIDATE_ACTION_RST;
        }

        @Override
        public WSTrustVersionInfo getValidateActionRstr() {
            return WSTrust13VersionInfo.VALIDATE_ACTION_RSTR;
        }

        @Override
        public WSTrustVersionInfo getValidateActionRstrFinal() {
            return WSTrust13VersionInfo.VALIDATE_ACTION_RSTR_FINAL;
        }

        public String toString() {
            return WSTrust13VersionInfo.DOCUMENT_NAMESPACE.getUri();
        }

        @Override
        public WSTrustVersionInfo getCorrespondingWSANamespace() {
            return WSTrust13VersionInfo.CORRESPONDING_WSA_URI;
        }

        @Override
        public WSTrustVersionInfo getCorrespondingWSPNamespace() {
            return WSTrust13VersionInfo.CORRESPONDING_WSP_URI;
        }

        @Override
        public String getProtocolManagerServiceId() {
            return WSTrustProtocolManager.class.getPackage().getName() + "." + WSTrust13ProtocolManager.class.getSimpleName();
        }

        @Override
        public WSTrustVersionInfo getStatus() {
            return WSTrust13VersionInfo.STATUS;
        }

        @Override
        public WSTrustVersionInfo getStatusInvalid() {
            return WSTrust13VersionInfo.STATUS_INVALID;
        }

        @Override
        public WSTrustVersionInfo getStatusValid() {
            return WSTrust13VersionInfo.STATUS_VALID;
        }

        @Override
        public boolean useResponseCollection() {
            return true;
        }

        @Override
        public String getVersion() {
            return "1.3";
        }

        @Override
        public String getResponseType() {
            return "RequestSecurityTokenResponseCollectionDocument";
        }
    }
    ,
    v2005{

        @Override
        public WSTrustVersionInfo getDocumentNamespace() {
            return WSTrust2005VersionInfo.DOCUMENT_NAMESPACE;
        }

        @Override
        public WSTrustVersionInfo getIssue() {
            return WSTrust2005VersionInfo.ISSUE;
        }

        @Override
        public WSTrustVersionInfo getIssueActionRst() {
            return WSTrust2005VersionInfo.ISSUE_ACTION_RST;
        }

        @Override
        public WSTrustVersionInfo getIssueActionRstr() {
            return WSTrust2005VersionInfo.ISSUE_ACTION_RSTR;
        }

        @Override
        public WSTrustVersionInfo getIssueActionRstrFinal() {
            throw new UnsupportedOperationException("RSTR Issue Final not implemented in WS-Trust v2005");
        }

        @Override
        public WSTrustVersionInfo getValidate() {
            return WSTrust2005VersionInfo.VALIDATE;
        }

        @Override
        public WSTrustVersionInfo getValidateActionRst() {
            return WSTrust2005VersionInfo.VALIDATE_ACTION_RST;
        }

        @Override
        public WSTrustVersionInfo getValidateActionRstr() {
            return WSTrust2005VersionInfo.VALIDATE_ACTION_RSTR;
        }

        @Override
        public WSTrustVersionInfo getValidateActionRstrFinal() {
            throw new UnsupportedOperationException("RSTR Validate Final not implemented in WS-Trust v2005");
        }

        public String toString() {
            return WSTrust2005VersionInfo.DOCUMENT_NAMESPACE.getUri();
        }

        @Override
        public WSTrustVersionInfo getCorrespondingWSANamespace() {
            return WSTrust2005VersionInfo.CORRESPONDING_WSA_URI;
        }

        @Override
        public WSTrustVersionInfo getCorrespondingWSPNamespace() {
            return WSTrust2005VersionInfo.CORRESPONDING_WSP_URI;
        }

        @Override
        public String getProtocolManagerServiceId() {
            return WSTrustProtocolManager.class.getPackage().getName() + "." + WSTrust2005ProtocolManager.class.getSimpleName();
        }

        @Override
        public WSTrustVersionInfo getStatus() {
            return WSTrust2005VersionInfo.STATUS;
        }

        @Override
        public WSTrustVersionInfo getStatusInvalid() {
            return WSTrust2005VersionInfo.STATUS_INVALID;
        }

        @Override
        public WSTrustVersionInfo getStatusValid() {
            return WSTrust2005VersionInfo.STATUS_VALID;
        }

        @Override
        public boolean useResponseCollection() {
            return false;
        }

        @Override
        public String getVersion() {
            return "1.2";
        }

        @Override
        public String getResponseType() {
            return "RequestSecurityTokenResponseDocument";
        }
    };


    public abstract WSTrustVersionInfo getDocumentNamespace();

    public abstract WSTrustVersionInfo getIssue();

    public abstract WSTrustVersionInfo getIssueActionRst();

    public abstract WSTrustVersionInfo getIssueActionRstr();

    public abstract WSTrustVersionInfo getIssueActionRstrFinal();

    public abstract WSTrustVersionInfo getValidate();

    public abstract WSTrustVersionInfo getValidateActionRst();

    public abstract WSTrustVersionInfo getValidateActionRstr();

    public abstract WSTrustVersionInfo getValidateActionRstrFinal();

    public abstract WSTrustVersionInfo getStatus();

    public abstract WSTrustVersionInfo getStatusValid();

    public abstract WSTrustVersionInfo getStatusInvalid();

    public abstract WSTrustVersionInfo getCorrespondingWSANamespace();

    public abstract WSTrustVersionInfo getCorrespondingWSPNamespace();

    public abstract String getProtocolManagerServiceId();

    public abstract boolean useResponseCollection();

    public abstract String getVersion();

    public abstract String getResponseType();

    public static WSTrustVersion fromDocumentNamespaceUri(String uri) throws WSTrustException {
        for (WSTrustVersion version : WSTrustVersion.values()) {
            if (!version.getDocumentNamespace().getUri().equals(WSTrustVersion.normalizeUri(uri))) continue;
            return version;
        }
        throw new WSTrustException(String.format("Unknown ws-trust version namespace: %s", uri));
    }

    private static String normalizeUri(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }
}

