/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.transport;

import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.KerberosTokenUtil;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.SecurityToken;

public enum HttpAuthnChallenge {
    KERBEROS("Negotiate", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");

    public static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final HashMap<String, HttpAuthnChallenge> challenge2Enum;
    private static final HashMap<String, HttpAuthnChallenge> token2Enum;
    private static Log LOG;
    private final String challengeType;
    private final String tokenType;

    private HttpAuthnChallenge(String challengeType, String tokenType) {
        this.challengeType = challengeType;
        this.tokenType = tokenType;
    }

    public String getChallengeType() {
        return this.challengeType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public static HttpAuthnChallenge fromChallengeType(String challengeType) {
        return challenge2Enum.get(challengeType);
    }

    public static HttpAuthnChallenge fromTokenType(String tokenType) {
        return token2Enum.get(tokenType);
    }

    public static SecurityToken createSecurityToken(String httpAuthnValue) {
        BinarySecurityToken result = null;
        int delimIndex = httpAuthnValue.indexOf(32);
        if (delimIndex > 0) {
            String challengeType = httpAuthnValue.substring(0, delimIndex);
            String challengeResponse = httpAuthnValue.substring(delimIndex + 1);
            if (HttpAuthnChallenge.KERBEROS.challengeType.equals(challengeType)) {
                try {
                    BinarySecurityToken kerbSecurityToken = new BinarySecurityToken(HttpAuthnChallenge.KERBEROS.tokenType);
                    byte[] spnegoToken = B64.decodeToBytes((String)challengeResponse);
                    byte[] kerbToken = KerberosTokenUtil.extractKerberosToken(spnegoToken);
                    kerbSecurityToken.setEncodedData(B64.encode((byte[])kerbToken));
                    result = kerbSecurityToken;
                }
                catch (KerberosException e) {
                    LOG.error((Object)e);
                }
            }
        }
        return result;
    }

    static {
        challenge2Enum = new HashMap(1, 1.0f);
        token2Enum = new HashMap(1, 1.0f);
        LOG = LogFactory.getLog(HttpAuthnChallenge.class);
        challenge2Enum.put(HttpAuthnChallenge.KERBEROS.challengeType, KERBEROS);
        token2Enum.put(HttpAuthnChallenge.KERBEROS.tokenType, KERBEROS);
    }
}

