/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.validator;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public class RequestContractValidator {
    private WsTrustRequestContractManager contractManager = GlobalRegistry.getService(WsTrustRequestContractManager.class);

    public void verify(WsTrustFederatedWscSettings settings, AttributeMap attributes) throws WSTrustException {
        if (settings.isRequestContractDefined() && settings.isAbortIfNotFulfilledFromRequest()) {
            WsTrustRequestContract contract = this.loadContract(settings);
            Set<String> required = contract.getMutableAttributeNames();
            if (attributes == null) {
                throw new WSTrustException(this.missedMsg(required));
            }
            Set actual = attributes.keySet();
            Collection missed = CollectionUtils.subtract(required, (Collection)actual);
            if (!missed.isEmpty()) {
                throw new WSTrustException(this.missedMsg(missed));
            }
        }
    }

    private WsTrustRequestContract loadContract(WsTrustFederatedWscSettings settings) {
        String id = settings.getRequestContractId();
        WsTrustRequestContract contract = this.contractManager.findById(id);
        if (contract == null) {
            throw new WSTrustException(String.format("RequestContract %s is not configured, but required. Double-check configuration.", id));
        }
        return contract;
    }

    private String missedMsg(Collection missed) {
        StringBuilder msg = new StringBuilder();
        msg.append("Ws-trust request contract is not fullfilled. Missed attributes:");
        for (Object name : missed) {
            msg.append(name);
            msg.append(",");
        }
        return msg.substring(0, msg.length() - 1);
    }
}

