/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.wsse;

import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.SecurityTokenReference;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.wsse.WsseProcessingException;

public class SecurityTokenReferenceProcessor {
    private SoapHeaders headers;

    public SecurityTokenReferenceProcessor(SoapHeaders headers) {
        this.headers = headers;
    }

    public SecurityToken resolveReference(SecurityTokenReference reference) throws WsseProcessingException {
        SecurityToken token;
        String uri = reference.getIdentifier();
        if (uri.startsWith("#")) {
            uri = uri.substring(1);
        }
        if ((token = this.headers.getTokenById(uri)) == null) {
            throw new WsseProcessingException(this.faultMsg(reference));
        }
        return token;
    }

    private String faultMsg(SecurityTokenReference reference) {
        String type = reference.getValueType();
        String msg = "Can't resolve token with id " + reference.getIdentifier();
        msg = msg + (String)(type == null ? " (no referenced token type given)." : " , of type:" + type + " (probably no token processor configured)");
        return msg;
    }
}

