/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.wsse;

import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.sourceid.common.Util;
import org.sourceid.websso.protocol.TimeConditionUtil;
import org.sourceid.wstrust.wsse.WsseProcessingException;

public class TimestampValidator
extends TimeConditionUtil {
    public void checkExpired(Date expires, Calendar now, boolean requireExpiry) throws WsseProcessingException {
        if (expires == null) {
            if (requireExpiry) {
                throw new WsseProcessingException("Timestamp does not contain expiry date.");
            }
        } else {
            try {
                Calendar notOnOrAfter = Util.getUtcCalendar();
                notOnOrAfter.setTime(expires);
                super.validateNotOnOrAfter(notOnOrAfter, now);
            }
            catch (TimeConditionUtil.TooFarInFutureException e) {
                if (requireExpiry) {
                    throw new WsseProcessingException(e.getMessage());
                }
            }
            catch (TimeConditionUtil.InvalidTimeConditionException e) {
                WsseProcessingException wssepe = new WsseProcessingException(e.getMessage());
                wssepe.setFaultCode(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "MessageExpired"));
                throw wssepe;
            }
        }
    }

    public void checkInFuture(Date created, Calendar now) {
        if (created != null) {
            Calendar notBefore = Util.getUtcCalendar();
            notBefore.setTime(created);
            try {
                super.validateNotBefore(notBefore, now);
            }
            catch (TimeConditionUtil.InvalidTimeConditionException e) {
                throw new WsseProcessingException(e.getMessage());
            }
        }
    }

    @Override
    protected String getNotBeforeMsgPattern() {
        return "Timestamp: now ({0}) is before created ({1}) and the adjusted tolerance created time ({2}).";
    }

    @Override
    protected String getNotOnOrAfterMessagePattern() {
        return "Timestamp: now ({0}) is on/after expires ({1}).";
    }

    @Override
    protected String getTooFarInFutureMessagePattern() {
        return "Timestamp: for security reasons expires ({0}) cannot be more than {1} minutes ahead of the current time ({2})";
    }
}

