/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.wsse;

import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.crypto.X509CertPathValidatorSupport;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.wstrust.crypto.IdBasedResolver;
import org.sourceid.wstrust.crypto.XmlCryptoProcessor;
import org.sourceid.wstrust.log.STSAuditLogger;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.Signature;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.Timestamp;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.model.X509SecurityToken;
import org.sourceid.wstrust.wsse.TimestampValidator;
import org.sourceid.wstrust.wsse.WsseProcessingException;

public class WsseProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private TimestampValidator timestampValidator = new TimestampValidator();
    private int messageValidityInMinutes;
    private TrustedCAsManager trustedCAsManager = GlobalRegistry.getService(TrustedCAsManager.class);
    private RevocationChecker revocationChecker = GlobalRegistry.getService(RevocationChecker.class);
    private XmlCryptoProcessor processor = new XmlCryptoProcessor();

    public XmlCryptoProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(XmlCryptoProcessor processor) {
        this.processor = processor;
    }

    public void setTimestampValidator(TimestampValidator timestampValidator) {
        this.timestampValidator = timestampValidator;
    }

    public int getMessageValidityInMinutes() {
        return this.messageValidityInMinutes;
    }

    public void setMessageValidityInMinutes(int messageValidityInMinutes) {
        this.messageValidityInMinutes = messageValidityInMinutes;
    }

    public TrustedCAsManager getTrustedCAsManager() {
        return this.trustedCAsManager;
    }

    public void setTrustedCAsManager(TrustedCAsManager trustedCAsManager) {
        this.trustedCAsManager = trustedCAsManager;
    }

    public void setRevocationChecker(RevocationChecker checker) {
        this.revocationChecker = checker;
    }

    public void process(WsTrustInMessageContext ctx) throws WsseProcessingException {
        SoapHeaders headers = ctx.getSoapHeaders();
        Signature signature = headers.getSignature();
        Timestamp timestamp = headers.getTimestamp();
        boolean requireExpiry = false;
        if (signature != null) {
            SecurityToken token = this.ensureReferencedTokenExists(ctx, signature);
            if (token != null) {
                X509SecurityToken x509SecurityToken = this.ensureSupportedSigningToken(token);
                if (x509SecurityToken != null) {
                    IdBasedResolver resolver = ctx.getResolver();
                    PublicKey publicKey = x509SecurityToken.getPublicKey();
                    X509Certificate[] chain = new X509Certificate[]{x509SecurityToken.getCertificate()};
                    this.ensureTrustedCert(chain);
                    this.ensureNotRevoked(chain);
                    XmlObject sigXml = signature.getXml();
                    XmlSignatureVerifier xmlSignatureVerifier = new XmlSignatureVerifier();
                    if (!xmlSignatureVerifier.validateRestrictions(XmlSignatureUtil.toDomElement(sigXml))) {
                        throw new WsseProcessingException("Message with an X509 token contains malformed signature data.");
                    }
                    boolean valid = this.processor.verify(sigXml, publicKey, resolver);
                    x509SecurityToken.setSignatureStatus(valid ? SignatureStatus.VALID : SignatureStatus.INVALID);
                    String tsMsg = "Message with an X509 token must contain a signed timestamp";
                    if (timestamp == null) {
                        throw new WsseProcessingException(tsMsg);
                    }
                    String id = timestamp.getId();
                    if (id == null) {
                        throw new WsseProcessingException(tsMsg + " but the timestamp has no id and is not covered by the signature.");
                    }
                    if (!signature.isIdReferenced(id)) {
                        throw new WsseProcessingException(tsMsg + " but timestamp with id=" + id + " is not covered by the signature.");
                    }
                    requireExpiry = true;
                } else {
                    this.log.warn((Object)("Not validating signature for message with token type: " + token.getType()));
                }
            } else {
                this.log.warn((Object)("Not validating signature for message, cannot locate validation credential with ID: " + signature.getTokenId()));
            }
        }
        if (timestamp != null) {
            Calendar now = Util.getUtcCalendar();
            this.timestampValidator.checkExpired(timestamp.getExpires(), now, requireExpiry);
            this.timestampValidator.checkInFuture(timestamp.getCreated(), now);
        }
    }

    private SecurityToken ensureReferencedTokenExists(WsTrustInMessageContext ctx, Signature sig) {
        String tokenId = sig.getTokenId();
        if (!ctx.containsToken(tokenId)) {
            this.log.warn((Object)("Unable to find token referenced by signature, wsu:Id=" + tokenId));
        }
        return ctx.getTokenById(tokenId);
    }

    private X509SecurityToken ensureSupportedSigningToken(SecurityToken token) {
        String type = token.getType();
        if (!X509SecurityToken.TYPE.equals(type)) {
            return null;
        }
        return (X509SecurityToken)token;
    }

    private void ensureTrustedCert(X509Certificate[] chain) throws WsseProcessingException {
        X509CertPathValidatorSupport pathValidator = new X509CertPathValidatorSupport(chain, true);
        pathValidator.addTrustAnchors(this.trustedCAsManager.getAllTrustAnchors());
        try {
            pathValidator.validate();
        }
        catch (CertPathValidatorException e) {
            STSAuditLogger.setDescription("Certificate path validation failed");
            STSAuditLogger.setStatus("failure");
            STSAuditLogger.log();
            throw new WsseProcessingException("Certificate path validation failed: ", e);
        }
    }

    private void ensureNotRevoked(X509Certificate[] chain) throws WsseProcessingException {
        try {
            this.revocationChecker.check(chain);
        }
        catch (RevokedCertException e) {
            STSAuditLogger.setDescription("Certificate revoked");
            STSAuditLogger.setStatus("failure");
            STSAuditLogger.log();
            throw new WsseProcessingException("Certificate revoked", e);
        }
    }

    private Date now() {
        return Util.getUtcCalendar().getTime();
    }

    public Timestamp generateTimestamp() {
        Date created = this.now();
        Calendar expires = Util.getUtcCalendar();
        expires.add(12, this.messageValidityInMinutes);
        return new Timestamp(UUID.randomUUID().toString(), created, expires.getTime());
    }

    public Timestamp generateTimestamp(Date created, Date expiry) {
        return new Timestamp(UUID.randomUUID().toString(), created, expiry);
    }
}

