/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.xpath;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class XPathNsContext
implements NamespaceContext {
    private Map<String, String> prefixToUri = new HashMap<String, String>();
    private Map<String, String> uriToPrefix = new HashMap<String, String>();
    public static final XPathNsContext instance = new XPathNsContext();

    private XPathNsContext() {
        this.prefixToUri.put("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.prefixToUri.put("ds", "http://www.w3.org/2000/09/xmldsig#");
        this.uriToPrefix = this.invert(this.prefixToUri);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.prefixToUri.get(prefix);
    }

    @Override
    public String getPrefix(String uri) {
        return this.uriToPrefix.get(uri);
    }

    public Iterator getPrefixes(String uri) {
        return Collections.singletonList(this.uriToPrefix.get(uri)).iterator();
    }

    private Map<String, String> invert(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> inverted = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            inverted.put(entry.getValue(), entry.getKey());
        }
        return inverted;
    }
}

