/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.rest.oauth.clientregistration.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pingidentity.admin.api.validator.DynamicClientRegistrationValidator;
import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.rest.oauth.clientregistration.error.handler.DynamicClientErrorHandler;
import com.pingidentity.rest.oauth.clientregistration.parser.DynamicClientJsonParser;
import com.pingidentity.rest.oauth.clientregistration.token.RegistrationAccessTokenManagementPlugin;
import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.sdk.oauth20.registration.ClientRegistrationException;
import com.pingidentity.sdk.oauth20.registration.DynamicClient;
import com.pingidentity.sdk.oauth20.registration.DynamicClientRegistrationPlugin;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.auth.BearerAuthHelp;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSecretRetentionHelper;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientUtil;
import org.sourceid.oauth20.domain.DynamicOAuthClient;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.OAuthDynamicClientRegistrationPluginManager;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.profiles.idp.ClientRegistrationAuditLogger;

@Produces(value={"application/json"})
@Path(value="/")
public class ClientRegistrationController {
    private static final String APPLICATION_JWT = "application/JWT";
    private final ConfigStore dynamicClientRegistrationConfigStore = ConfigStoreFarm.getConfig((String)"dynamic-client-registration");
    private final String CLIENT_ID_PREFIX = this.dynamicClientRegistrationConfigStore.getStringValue("prefix", "");
    private final ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
    @Context
    private HttpServletRequest req = null;
    @Context
    HttpServletResponse resp;
    private static final ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(ClientRegistrationController.class);
    private static final OAuthDynamicClientRegistrationPluginManager CLIENT_REGISTRATION_POLICY_MGR = MgmtFactory.getOAuthDynamicClientRegistrationPluginManager();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();

    @GET
    @Consumes
    public Response getClients() {
        return Response.status((int)404).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{clientId}")
    @Consumes
    public Response getClient(@PathParam(value="clientId") String clientId) {
        ClientRegistrationAuditLogger.init();
        ClientRegistrationAuditLogger.setRequestStartTime((HttpServletRequest)this.req);
        ClientRegistrationAuditLogger.setRemoteAddress((String)this.req.getRemoteAddr());
        ClientRegistrationAuditLogger.setClientId((String)clientId);
        this.oAuthIssuerUtils.setAuditLogVirtualServerIdIfApplicable(this.req);
        try {
            boolean updateClient;
            log.debug("Retrieving a client");
            DynamicOAuthClient dynamicOAuthClient = this.validateRequest(clientId);
            this.processPolicies(null, dynamicOAuthClient, this.req, this.resp, null);
            if (ClientSecretRetentionHelper.isRetainClientSecret((Client)dynamicOAuthClient)) {
                dynamicOAuthClient.addCurrentSecretToSecondary();
            }
            ClientUtil.setClientAuthnSource((DynamicOAuthClient)dynamicOAuthClient);
            this.setRegistrationKey(dynamicOAuthClient);
            boolean bl = updateClient = dynamicOAuthClient.isForceSecretChange() != false || dynamicOAuthClient.isForceRegistrationAccessTokenChange();
            if (updateClient) {
                this.updateClient(dynamicOAuthClient);
            }
            DynamicClientJsonParser clientParser = new DynamicClientJsonParser();
            JsonNode response = clientParser.compose(dynamicOAuthClient, this.req);
            ClientRegistrationAuditLogger.setOutXmlMessage((String)objectMapper.writeValueAsString((Object)response));
            ClientRegistrationAuditLogger.log((String)"Client Retrieved");
            Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
            return response2;
        }
        catch (ClientRegistrationException e) {
            String error = "Client retrieval failed";
            log.debug(error, (Throwable)e);
            Response response = this.getErrorResponse(e.getStatus(), e.getError(), e.getMessage());
            this.auditError(error, response);
            Response response3 = response;
            return response3;
        }
        catch (Exception e) {
            String error = "Client retrieval failed";
            log.error(error, (Object)e.getMessage());
            log.debug(error, (Throwable)e);
            Response response = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, ClientRegistrationException.ErrorCode.internal_error, error);
            this.auditError(error, response);
            Response response4 = response;
            return response4;
        }
        finally {
            ClientRegistrationAuditLogger.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes
    public Response registerClient(String body) {
        ClientRegistrationAuditLogger.init();
        ClientRegistrationAuditLogger.setRequestStartTime((HttpServletRequest)this.req);
        ClientRegistrationAuditLogger.setRemoteAddress((String)this.req.getRemoteAddr());
        ClientRegistrationAuditLogger.setInXmlMessage((String)body);
        this.oAuthIssuerUtils.setAuditLogVirtualServerIdIfApplicable(this.req);
        try {
            DynamicOAuthClient client;
            log.debug("Registering a new client");
            String tokenString = BearerAuthHelp.getAuthTokenFromHeaders((HttpServletRequest)this.req);
            this.validateInitialAccessToken(tokenString);
            DynamicClientJsonParser clientParser = new DynamicClientJsonParser();
            String contentType = this.req.getHeader("Content-Type");
            log.debug("Request content type : [{}]", (Object)contentType);
            if (contentType == null || !StringUtils.containsIgnoreCase((String)contentType, (String)"application/json") && !StringUtils.containsIgnoreCase((String)contentType, (String)APPLICATION_JWT)) {
                String message = "Please provide a Content-Type of 'application/json' or 'application/JWT'.";
                log.error(message);
                throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, message);
            }
            if (contentType.toLowerCase().contains("application/json")) {
                log.debug("Parsing input JSON");
                JsonNode jsonNode = objectMapper.readTree(body);
                client = clientParser.parse(jsonNode, false);
            } else {
                client = new DynamicOAuthClient();
            }
            this.populateDefaultValues(client, false);
            if (!this.validateResponseTypes(client)) {
                log.error("Invalid response_types value");
                String message = "Please provide a valid response_types value";
                throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, message);
            }
            this.processPolicies(client, null, this.req, this.resp, body);
            this.setPostPolicyProcessDefaultValues(client);
            this.validateClientForRegistration(client);
            this.validate(client, false);
            this.saveClient(client);
            JsonNode response = clientParser.compose(client, this.req);
            ClientRegistrationAuditLogger.setClientId((String)client.getClientId());
            ClientRegistrationAuditLogger.setOutXmlMessage((String)objectMapper.writeValueAsString((Object)response));
            ClientRegistrationAuditLogger.log((String)"Client Created");
            log.info("Client was created successfully");
            Response response2 = Response.status((Response.Status)Response.Status.CREATED).entity((Object)response).build();
            return response2;
        }
        catch (ClientRegistrationException e) {
            String error = "Client registration failed";
            log.debug(error, (Throwable)e);
            Response response = this.getErrorResponse(e.getStatus(), e.getError(), e.getMessage());
            this.auditError(error, response);
            Response response3 = response;
            return response3;
        }
        catch (JsonParseException | JsonMappingException e) {
            String error = "Invalid JSON payload";
            log.error(error, (Object)e.getMessage());
            log.debug(error, e);
            Response response = this.getErrorResponse(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_payload, error);
            this.auditError(error, response);
            Response response4 = response;
            return response4;
        }
        catch (Exception e) {
            String error = "Client registration failed";
            log.error(error, (Object)e.getMessage());
            log.debug(error, (Throwable)e);
            Response response = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, ClientRegistrationException.ErrorCode.internal_error, error);
            this.auditError(error, response);
            Response response5 = response;
            return response5;
        }
        finally {
            ClientRegistrationAuditLogger.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{clientId}")
    @Consumes
    public Response updateClient(@PathParam(value="clientId") String clientId, String body) {
        ClientRegistrationAuditLogger.init();
        ClientRegistrationAuditLogger.setRequestStartTime((HttpServletRequest)this.req);
        ClientRegistrationAuditLogger.setRemoteAddress((String)this.req.getRemoteAddr());
        ClientRegistrationAuditLogger.setInXmlMessage((String)body);
        ClientRegistrationAuditLogger.setClientId((String)clientId);
        this.oAuthIssuerUtils.setAuditLogVirtualServerIdIfApplicable(this.req);
        try {
            DynamicOAuthClient client;
            log.debug("Updating a client");
            DynamicOAuthClient existingClient = this.validateRequest(clientId);
            String contentType = this.req.getHeader("Content-Type");
            log.debug("Request content type : [{}]", (Object)contentType);
            if (contentType == null || !StringUtils.containsIgnoreCase((String)contentType, (String)"application/json") && !StringUtils.containsIgnoreCase((String)contentType, (String)APPLICATION_JWT)) {
                String message = "Please provide a Content-Type of 'application/json' or 'application/JWT'.";
                log.error(message);
                throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, message);
            }
            DynamicClientJsonParser clientParser = new DynamicClientJsonParser();
            if (contentType.toLowerCase().contains("application/json")) {
                log.debug("Parsing input JSON");
                JsonNode jsonNode = objectMapper.readTree(body);
                client = clientParser.parse(jsonNode, true);
            } else {
                client = existingClient;
            }
            Boolean existingClientForceSecretChange = existingClient.isForceSecretChange();
            client.setForceSecretChange(Boolean.valueOf(true));
            this.validateClientForUpdate(clientId, client, (Client)existingClient);
            this.populateDefaultValues(client, true);
            this.processPolicies(client, existingClient, this.req, this.resp, body);
            this.merge(client, existingClient);
            this.setPostPolicyProcessDefaultValues(client);
            this.validateClientForRegistration(client);
            this.validate(client, true);
            this.updateClient(client);
            client.setForceSecretChange(existingClientForceSecretChange);
            JsonNode response = clientParser.compose(client, this.req);
            ClientRegistrationAuditLogger.setOutXmlMessage((String)objectMapper.writeValueAsString((Object)response));
            ClientRegistrationAuditLogger.log((String)"Client Updated");
            log.info("Client was updated successfully");
            Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
            return response2;
        }
        catch (ClientRegistrationException e) {
            String error = "Client update failed";
            log.debug(error, (Throwable)e);
            Response response = this.getErrorResponse(e.getStatus(), e.getError(), e.getMessage());
            this.auditError(error, response);
            Response response3 = response;
            return response3;
        }
        catch (JsonParseException | JsonMappingException e) {
            String error = "Invalid JSON payload";
            log.error(error, (Object)e.getMessage());
            log.debug(error, e);
            Response response = this.getErrorResponse(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_payload, error);
            this.auditError(error, response);
            Response response4 = response;
            return response4;
        }
        catch (Exception e) {
            String error = "Client update failed";
            log.error(error, (Object)e.getMessage());
            log.debug(error, (Throwable)e);
            Response response = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, ClientRegistrationException.ErrorCode.internal_error, error);
            this.auditError(error, response);
            Response response5 = response;
            return response5;
        }
        finally {
            ClientRegistrationAuditLogger.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{clientId}")
    @Consumes
    public Response deleteClient(@PathParam(value="clientId") String clientId) {
        ClientRegistrationAuditLogger.init();
        ClientRegistrationAuditLogger.setRequestStartTime((HttpServletRequest)this.req);
        ClientRegistrationAuditLogger.setRemoteAddress((String)this.req.getRemoteAddr());
        ClientRegistrationAuditLogger.setClientId((String)clientId);
        this.oAuthIssuerUtils.setAuditLogVirtualServerIdIfApplicable(this.req);
        try {
            log.debug("Deleting a client");
            if (this.clientSetting.isEnableDynamicClientRegistrationManagement() && !this.clientSetting.isAllowClientDelete()) {
                String error = "Client delete not allowed";
                log.debug(error);
                Response response = Response.status((int)405).build();
                this.auditError(error, response);
                Response response2 = response;
                return response2;
            }
            DynamicOAuthClient client = this.validateRequest(clientId);
            this.processPolicies(null, client, this.req, this.resp, null);
            MgmtFactory.getClientManager().deleteClient(clientId);
            BearerAccessTokenMgmtPluginManager manager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
            manager.revokeAccessTokens((Client)client);
            ClientRegistrationAuditLogger.log((String)"Client Deleted");
            log.info("Client was deleted successfully");
            Response response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            return response;
        }
        catch (ClientRegistrationException e) {
            String error = "Client delete failed";
            log.debug(error, (Throwable)e);
            Response response = this.getErrorResponse(e.getStatus(), e.getError(), e.getMessage());
            this.auditError(error, response);
            Response response3 = response;
            return response3;
        }
        catch (Exception e) {
            String error = "Client delete failed";
            log.error(error, (Object)e.getMessage());
            log.debug(error, (Throwable)e);
            Response response = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, ClientRegistrationException.ErrorCode.internal_error, error);
            this.auditError(error, response);
            Response response4 = response;
            return response4;
        }
        finally {
            ClientRegistrationAuditLogger.cleanup();
        }
    }

    private void setRegistrationKey(DynamicOAuthClient client) {
        if (this.clientSetting.isEnableDynamicClientRegistrationManagement() && !this.clientSetting.isDisableRegistrationAccessTokens()) {
            if (this.clientSetting.isRotateRegistrationAccessToken() || client.getRegistrationAccessToken() == null) {
                client.setForceRegistrationAccessTokenChange(true);
                RegistrationAccessTokenManagementPlugin manager = new RegistrationAccessTokenManagementPlugin((Client)client);
                HashedPassword token = HashedPassword.fromClearText((String)manager.issueAccessToken(null, null, null, null).getTokenValue());
                client.setRegistrationAccessToken(token);
            }
            ClientRegistrationAuditLogger.setOutAccessTokenHash((String)client.getRegistrationAccessToken().getSecret());
        }
    }

    private void setLogoutMode(DynamicOAuthClient client) {
        if (client.getBackChannelLogoutUri() != null) {
            client.setLogoutMode(ClientLogoutMode.OIDC_BACK_CHANNEL);
        } else if (!Util.isEmpty((Collection)client.getLogoutUris())) {
            client.setLogoutMode(ClientLogoutMode.OIDC_FRONT_CHANNEL);
        } else {
            client.setLogoutMode(ClientLogoutMode.NONE);
        }
    }

    private void setPostPolicyProcessDefaultValues(DynamicOAuthClient client) {
        log.debug("Applying post policy process default values.");
        ClientUtil.setDefaultClientRegistrationGrantTypesAndResponseTypes((Client)client);
        ClientUtil.setClientAuthnSource((DynamicOAuthClient)client);
        ClientUtil.setIdTokenSigningAlgo((DynamicOAuthClient)client);
        ClientUtil.setCibaDefaults((DynamicOAuthClient)client);
        this.setRegistrationKey(client);
        this.setLogoutMode(client);
    }

    private void validateClientForRegistration(DynamicOAuthClient client) throws ClientRegistrationException {
        if (client.getGrantTypes().contains("extension")) {
            String message = "Please provide a valid grant_types value";
            log.error(message);
            throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, message);
        }
        if (client.getGrantTypes().contains("urn:ietf:params:oauth:grant-type:jwt-bearer")) {
            client.getGrantTypes().remove("urn:ietf:params:oauth:grant-type:jwt-bearer");
            client.getGrantTypes().add("extension");
        }
        if (client.getGrantTypes().contains("urn:ietf:params:oauth:grant-type:saml2-bearer")) {
            client.getGrantTypes().remove("urn:ietf:params:oauth:grant-type:saml2-bearer");
            client.getGrantTypes().add("extension");
        }
    }

    private void validateClientForUpdate(String clientId, DynamicOAuthClient client, Client existingClient) throws ClientRegistrationException {
        if (!this.validateResponseTypes(client)) {
            log.error("Invalid response_types value");
            String message = "Please provide a valid response_types value";
            throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, message);
        }
        if (StringUtils.isBlank((String)client.getClientId()) || !clientId.equals(client.getClientId())) {
            log.error("Invalid client_id value");
            String message = "The client_id in the request does not match the value associated with this client.";
            throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, message);
        }
        if ((client.getClientAuthnType() == ClientAuthenticationType.SECRET || client.isClientSecretJwtAuthn()) && client.getSecret() != null) {
            if (existingClient.getReversableSecretAsString() != null && !client.getSecret().equals(existingClient.getReversableSecretAsString()) || existingClient.hasSecret() && !existingClient.isPrimarySecret(client.getSecret())) {
                log.error("Invalid client_secret value");
                String message = "The client secret does not match the existing client secret";
                throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, message);
            }
            if (existingClient.hasSecret() && existingClient.getReversableSecretAsString() == null) {
                existingClient.setSecret(client.getSecret());
            }
        }
    }

    private boolean validateResponseTypes(DynamicOAuthClient client) {
        return client.getRestrictedResponseTypes().size() != 0 || !client.getGrantTypes().contains("implicit");
    }

    private void auditError(String error, Response response) {
        ClientRegistrationAuditLogger.setStatus((String)"failure");
        try {
            ClientRegistrationAuditLogger.setOutXmlMessage((String)objectMapper.writeValueAsString(response.getEntity()));
        }
        catch (JsonProcessingException e) {
            log.debug("Failed to include raw response");
        }
        ClientRegistrationAuditLogger.log((String)error);
        ClientRegistrationAuditLogger.cleanup();
    }

    private void saveClient(DynamicOAuthClient client) throws ClientRegistrationException {
        try {
            MgmtFactory.getClientManager().addClient((Client)client);
        }
        catch (ClientManager.ClientManagementException e) {
            String message = "Failed to save the client";
            log.error(message + " : {}", (Object)e.getMessage());
            log.debug(message + " : ", (Throwable)e);
            throw new ClientRegistrationException(Response.Status.INTERNAL_SERVER_ERROR, ClientRegistrationException.ErrorCode.internal_error, message);
        }
    }

    private void updateClient(DynamicOAuthClient client) throws ClientRegistrationException {
        try {
            MgmtFactory.getClientManager().updateClient((Client)client);
        }
        catch (ClientManager.ClientManagementException e) {
            String message = "Failed to update the client";
            log.error(message + " : {}", (Object)e.getMessage());
            log.debug(message + " : ", (Throwable)e);
            throw new ClientRegistrationException(Response.Status.INTERNAL_SERVER_ERROR, ClientRegistrationException.ErrorCode.internal_error, message);
        }
    }

    private void validate(DynamicOAuthClient client, boolean isUpdate) throws ClientRegistrationException {
        DynamicClientRegistrationValidator validator = new DynamicClientRegistrationValidator((Client)client, this.clientSetting, isUpdate);
        validator.validate();
        DynamicClientErrorHandler handler = new DynamicClientErrorHandler((Validator)validator);
        handler.handle();
    }

    private void populateDefaultValues(DynamicOAuthClient client, boolean isUpdate) {
        log.debug("Applying default values.");
        if (!isUpdate) {
            String allowedChars = "abcdefghijklmnopqrstuvwxyz0123456789";
            String id = this.CLIENT_ID_PREFIX + IDGenerator.rndStr((int)25, (char[])allowedChars.toCharArray());
            client.setClientId(id);
            if (StringUtils.isBlank((String)client.getName())) {
                client.setName(id);
            }
        }
        if (client.getSpecifiedClientAuthnType() == null) {
            client.setClientAuthnType(ClientAuthenticationType.SECRET);
        }
        if (client.getClientAuthnType() == ClientAuthenticationType.NONE) {
            client.setEncodedSecret(null);
        }
        client.setEnforceReplayPrevention(Boolean.valueOf(this.clientSetting.isEnforceReplayPrevention()));
        client.setRequireSignedRequests(this.clientSetting.isRequireSignedRequests());
        if (StringUtils.isNotBlank((String)client.getRequestObjectSigningAlgorithm())) {
            client.setRequireSignedRequests(true);
        }
        if (StringUtils.isNotEmpty((String)this.clientSetting.getDefaultAccessTokenManagerId())) {
            client.setDefaultAccessTokenManagerId(this.clientSetting.getDefaultAccessTokenManagerId());
        }
        client.setRestrictToDefaultAccessTokenManager(this.clientSetting.isRestrictToDefaultAccessTokenManager());
        client.setPersistentGrantExpirationType(this.clientSetting.getPersistentGrantExpirationType());
        client.setPersistentGrantExpirationTime(this.clientSetting.getPersistentGrantExpirationTime());
        client.setPersistentGrantExpirationTimeUnit(this.clientSetting.getPersistentGrantExpirationTimeUnit());
        client.setPersistentGrantIdleTimeoutType(this.clientSetting.getPersistentGrantIdleTimeoutType());
        client.setPersistentGrantIdleTimeout(this.clientSetting.getPersistentGrantIdleTimeout());
        client.setPersistentGrantIdleTimeoutTimeUnit(this.clientSetting.getPersistentGrantIdleTimeoutTimeUnit());
        client.setRefreshRolling(this.clientSetting.getRefreshRolling());
        client.setRefreshTokenRollingInterval(this.clientSetting.getRefreshTokenRollingInterval());
        if (this.clientSetting.getRefreshTokenRollingInterval() == null) {
            client.setRefreshTokenRollingIntervalType("SERVER_DEFAULT");
            client.setRefreshTokenRollingIntervalTimeUnit(null);
        } else {
            client.setRefreshTokenRollingIntervalType("OVERRIDE_SERVER_DEFAULT");
            client.setRefreshTokenRollingIntervalTimeUnit(this.clientSetting.getRefreshTokenRollingIntervalTimeUnit());
        }
        client.setClientCertIssuerDn(this.clientSetting.getClientCertIssuerDn());
        client.setDeviceFlowSettingType(this.clientSetting.getDeviceFlowSettingType());
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.clientSetting.getDeviceFlowSettingType())) {
            client.setUserAuthzUrlOverride(this.clientSetting.getUserAuthzUrlOverride());
            client.setPendingAuthzTimeoutOverride(this.clientSetting.getPendingAuthzTimeoutOverride() != null ? String.valueOf(this.clientSetting.getPendingAuthzTimeoutOverride()) : null);
            client.setDevicePollingIntervalOverride(this.clientSetting.getDevicePollingIntervalOverride() != null ? String.valueOf(this.clientSetting.getDevicePollingIntervalOverride()) : null);
            client.setBypassActivationCodeConfirmationOverride(this.clientSetting.getBypassActivationCodeConfirmationOverride());
        }
        client.setRequireProofKeyForCodeExchange(this.clientSetting.isRequireProofKeyForCodeExchange());
        if (client.getGrantTypes().contains("urn:ietf:params:oauth:grant-type:token-exchange") && StringUtils.isNotBlank((String)this.clientSetting.getTokenExchangeProcessorPolicyId())) {
            client.setTokenExchangeProcessorPolicyId(this.clientSetting.getTokenExchangeProcessorPolicyId());
        }
        client.setRefreshTokenRollingGracePeriodType(this.clientSetting.getRefreshTokenRollingGracePeriodType());
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.clientSetting.getRefreshTokenRollingGracePeriodType())) {
            client.setRefreshTokenRollingGracePeriod(this.clientSetting.getRefreshTokenRollingGracePeriod());
        }
        if (this.clientSetting.isRetainClientSecret()) {
            client.setSecondarySecretRetentionPeriodType(this.clientSetting.getClientSecretRetentionPeriodType());
            if (this.clientSetting.getClientSecretRetentionPeriod() != null) {
                client.setSecondarySecretRetentionPeriod(String.valueOf(this.clientSetting.getClientSecretRetentionPeriod()));
            }
        } else {
            client.setSecondarySecretRetentionPeriodType("OVERRIDE_SERVER_DEFAULT");
            client.setSecondarySecretRetentionPeriod(String.valueOf(0));
        }
        boolean requireJarm = this.clientSetting.getRequireJwtSecuredAuthorizationResponseMode() != null && this.clientSetting.getRequireJwtSecuredAuthorizationResponseMode() != false;
        client.setRequireJwtSecuredAuthorizationResponseMode(requireJarm);
        client.setRequireOfflineAccessScopeToIssueRefreshTokens(this.clientSetting.getRequireOfflineAccessScopeToIssueRefreshTokens());
        client.setOfflineAccessRequireConsentPrompt(this.clientSetting.getOfflineAccessRequireConsentPrompt());
        client.setLockoutMaxMaliciousActionsType(this.clientSetting.getLockoutMaxMaliciousActionsType());
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.clientSetting.getLockoutMaxMaliciousActionsType())) {
            client.setLockoutMaxMaliciousActions(this.clientSetting.getLockoutMaxMaliciousActions());
        }
    }

    private Response getErrorResponse(Response.Status status, ClientRegistrationException.ErrorCode error, String errorString) {
        ObjectNode response = objectMapper.createObjectNode();
        response.put("error", error.toString());
        response.put("error_description", errorString);
        return Response.status((Response.Status)status).entity((Object)response).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateInitialAccessToken(String tokenString) throws ClientRegistrationException {
        String defaultAtmId;
        if (!this.clientSetting.isRequireInitialAccessToken()) return;
        String errorDescription = "Please provide a valid Access Token with the correct scope.";
        if (StringUtils.isBlank((String)tokenString)) {
            String desc = "Initial access token is required";
            log.error(desc);
            ClientRegistrationAuditLogger.setDescription((String)desc);
            throw new ClientRegistrationException(Response.Status.UNAUTHORIZED, ClientRegistrationException.ErrorCode.invalid_access_token, errorDescription);
        }
        List atmInstances = this.getAtmInstances().parallelStream().map(ConfigAbstract::getId).collect(Collectors.toList());
        if (atmInstances.size() > 1 && (defaultAtmId = this.getDefaultAtmInstanceId()) != null) {
            atmInstances.remove(defaultAtmId);
            atmInstances.add(0, defaultAtmId);
        }
        ClientRegistrationAuditLogger.setAccessTokenTrackingId((String)tokenString);
        ClientRegistrationAuditLogger.setInAccessTokenHash((String)tokenString);
        AccessToken accessToken = this.getTokenManager().validateAccessToken(atmInstances, tokenString).getAccessToken();
        if (accessToken != null && !accessToken.isExpired()) {
            Scope requiredAccessTokenScope = new Scope(this.clientSetting.getInitialAccessTokenScope());
            Scope providedScope = new Scope(accessToken.getScope());
            boolean isValid = providedScope.hasAllScopes(requiredAccessTokenScope);
            if (isValid) {
                ClientRegistrationAuditLogger.setAttributes((Map)accessToken.getAttributes());
                return;
            }
            String desc = "Initial access token's scope does not match the expected scope.";
            log.error(desc);
            ClientRegistrationAuditLogger.setDescription((String)desc);
            throw new ClientRegistrationException(Response.Status.UNAUTHORIZED, ClientRegistrationException.ErrorCode.invalid_access_token, errorDescription);
        }
        String desc = "Initial access token is invalid or expired";
        log.error(desc);
        ClientRegistrationAuditLogger.setDescription((String)desc);
        throw new ClientRegistrationException(Response.Status.UNAUTHORIZED, ClientRegistrationException.ErrorCode.invalid_access_token, errorDescription);
    }

    private void validateRegistrationAccessToken(Client client, String tokenString) throws ClientRegistrationException {
        RegistrationAccessTokenManagementPlugin tokenManager = new RegistrationAccessTokenManagementPlugin(client);
        AccessToken accessToken = tokenManager.validateAccessToken(tokenString);
        if (accessToken == null) {
            String desc = "Registration access token is invalid";
            log.error(desc);
            ClientRegistrationAuditLogger.setDescription((String)desc);
            throw new ClientRegistrationException(Response.Status.UNAUTHORIZED, ClientRegistrationException.ErrorCode.invalid_access_token, desc);
        }
    }

    private void processPolicies(DynamicOAuthClient client, DynamicOAuthClient existingClient, HttpServletRequest req, HttpServletResponse resp, String body) throws Exception {
        List policyPlugins = this.clientSetting.getPolicyPlugins();
        if (policyPlugins != null && !policyPlugins.isEmpty()) {
            HashMap<String, String> inParameters = new HashMap<String, String>();
            inParameters.put("com.pingidentity.oauth.client.registration.request.body", body);
            inParameters.put("com.pingidentity.oauth.client.registration.request.content-type", req.getHeader("Content-Type"));
            for (String instanceId : policyPlugins) {
                log.debug("Processing [{}] policy plugin", (Object)instanceId);
                DynamicClientRegistrationPlugin instance = CLIENT_REGISTRATION_POLICY_MGR.getPolicyPlugin(instanceId);
                if (instance != null) {
                    switch (req.getMethod()) {
                        case "GET": {
                            instance.processPluginGet(req, resp, (DynamicClient)existingClient, inParameters);
                            break;
                        }
                        case "DELETE": {
                            instance.processPluginDelete(req, resp, (DynamicClient)existingClient, inParameters);
                            break;
                        }
                        case "PUT": {
                            instance.processPluginUpdate(req, resp, (DynamicClient)client, (DynamicClient)existingClient, inParameters);
                            break;
                        }
                        case "POST": {
                            instance.processPlugin(req, resp, (DynamicClient)client, inParameters);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    continue;
                }
                String message = "Unable to obtain an instance of [" + instanceId + "] policy plugin";
                log.error(message);
                throw new Exception(message);
            }
        }
    }

    private Collection<BearerAccessTokenMgmtPluginInstance> getAtmInstances() {
        return MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances();
    }

    private String getDefaultAtmInstanceId() {
        return ((BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getDefaultInstance()).getId();
    }

    private BearerAccessTokenMgmtPluginManager getTokenManager() {
        return MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    }

    private DynamicOAuthClient validateRequest(String clientId) throws ClientRegistrationException {
        String tokenString = BearerAuthHelp.getAuthTokenFromHeaders((HttpServletRequest)this.req);
        ClientRegistrationAuditLogger.setAccessTokenTrackingId((String)tokenString);
        ClientRegistrationAuditLogger.setInAccessTokenHash((String)tokenString);
        if (!this.clientSetting.isEnableDynamicClientRegistrationManagement()) {
            throw new ClientRegistrationException(Response.Status.NOT_FOUND, ClientRegistrationException.ErrorCode.resource_not_found, "Resource not found.");
        }
        Client client = MgmtFactory.getClientManager().getClient(clientId);
        if (client == null || !client.isEnabled()) {
            ClientRegistrationAuditLogger.setClientId((String)clientId);
            throw new ClientRegistrationException(Response.Status.UNAUTHORIZED, ClientRegistrationException.ErrorCode.unauthorized, "Unauthorized.");
        }
        if (!this.clientSetting.isDisableRegistrationAccessTokens()) {
            this.validateRegistrationAccessToken(client, tokenString);
            client.setRegistrationAccessToken(HashedPassword.fromClearText((String)tokenString));
        }
        return new DynamicOAuthClient(client);
    }

    private void merge(DynamicOAuthClient client, DynamicOAuthClient existingClient) {
        if (existingClient != null) {
            if ((client.getClientAuthnType() != ClientAuthenticationType.NONE || client.needReversibleSecret()) && StringUtils.isNotBlank((String)existingClient.getEncodedSecret())) {
                client.setEncodedSecret(existingClient.getEncodedSecret());
                if (ClientSecretRetentionHelper.isRetainClientSecret((Client)existingClient)) {
                    client.copySecondarySecrets(existingClient.getSecondarySecrets());
                    client.addCurrentSecretToSecondary();
                }
                client.getSupplementalInfo().put("REVERSIBLE_SECRET", existingClient.getSupplementalInfo("REVERSIBLE_SECRET"));
            }
            client.setCreationTime(existingClient.getCreationTime());
            client.setRegistrationAccessToken(existingClient.getRegistrationAccessToken());
        }
    }
}

