/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration;

import com.pingidentity.common.upgrade.ConfigStoreFileMigrator;
import com.pingidentity.common.upgrade.DataDirectoryMigrator;
import com.pingidentity.common.upgrade.FileMigrationManager;
import com.pingidentity.common.upgrade.FileMigrator;
import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.PingFederateDirectoryInfo;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStoreFileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.pingcommons.upgrade.file.PropertyMigrator;
import com.pingidentity.pingcommons.upgrade.file.PropertyRemover;
import com.pingidentity.pingfederate.migration.AdminRolePropertyName;
import com.pingidentity.pingfederate.migration.exception.UpgradeException;
import com.pingidentity.pingfederate.migration.featurehandler.AJPConnectorHandler;
import com.pingidentity.pingfederate.migration.featurehandler.DeprecatedServicesHandler;
import com.pingidentity.pingfederate.migration.featurehandler.EmailSettingHandler;
import com.pingidentity.pingfederate.migration.featurehandler.LunaSupportHandler;
import com.pingidentity.pingfederate.migration.featurehandler.SnmpConfigurationHandler;
import com.pingidentity.pingfederate.migration.file.ArchiveFileMigrator;
import com.pingidentity.pingfederate.migration.file.HivemoduleMigrator;
import com.pingidentity.pingfederate.migration.file.PropertyFileMigrator;
import com.pingidentity.pingfederate.migration.file.custom.AltAuthnSourceDependentTemplateFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.CopyIfModifiedCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.HivemoduleCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.JvmMemoryOptionsCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.LicenseFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.Log4j2ConfigFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.Log4jConfigFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.PingIDPcvLibCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.TcpUdpXmlFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.TemplateFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.VelocityTemplateFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.GoogleConnectorCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.IWACustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.JettyPatchesCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.KeepLatestJarCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.KerberosTokenTranslatorAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.LdapAdapterCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.OpenTokenAdapterCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.PingIDRadiusPCVPackageCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.PingOnePcvCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.SalesforcePartnerApiCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.UsernameTokenProcessorCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.kit.AgentlessIKCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.kit.GenericBundledKitCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.kit.PingIdConnectorKitCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.kit.PingOneConnectorKitCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.kit.PingOneServiceKitCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.kit.X509AdapterCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.propertyfile.IntegrationKitLanguagePackPropertyFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.propertyfile.LanguagePackPropertyFileCustomAction;
import com.pingidentity.pingfederate.migration.migrator.AdminRolePropertyAppender;
import com.pingidentity.pingfederate.migration.migrator.AdminRolePropertyMigrator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PingFederateMigrator {
    private static final Charset LANGUAGE_PACK_PROPERTY_FILE_CHARSET = StandardCharsets.UTF_8;
    private static final Logger log = LogManager.getLogger(PingFederateMigrator.class);
    public static final String EXPRESSION_ADMIN_MIGRATION_SUPPORT_VERSION = "10.1.0";
    public static final String DATA_COLLECTION_ADMIN_MIGRATION_SUPPORT_VERSION = "12.2.0";
    public static final String REQUEST_LOG_MIGRATION_SUPPORT_VERSION = "12.3.0";
    private final String sourceRootDir;
    private final String destinationRootDir;
    private final String sourcePFVersion;
    private final String mode;
    private final String licenseFileLocation;
    private final String sourceOperationalMode;
    private final String destinationPFVersion;
    private final PingFederateDirectoryInfo pingFederateDirectoryInfo;
    private final FileMigrationManager fileMigrationManager;

    public PingFederateMigrator(String sPath, String dPath, String hDir, String sVersion, String md, String srcOpMode, String dVersion, String licenseLocation) {
        this.sourcePFVersion = sVersion;
        this.mode = md;
        this.licenseFileLocation = licenseLocation;
        this.sourceOperationalMode = srcOpMode;
        this.destinationPFVersion = dVersion;
        this.pingFederateDirectoryInfo = PingFederateDirectoryInfo.getInstance();
        this.pingFederateDirectoryInfo.setSourceRootDir(sPath);
        this.pingFederateDirectoryInfo.setDestinationRootDir(dPath);
        this.pingFederateDirectoryInfo.setSourcePFVersion(sVersion);
        this.pingFederateDirectoryInfo.setHomeDir(hDir);
        this.sourceRootDir = this.pingFederateDirectoryInfo.getSourceRootDir();
        this.destinationRootDir = this.pingFederateDirectoryInfo.getDestinationRootDir();
        this.fileMigrationManager = new FileMigrationManager(this.sourceRootDir, this.destinationRootDir, this.pingFederateDirectoryInfo.getReferenceFilesRootDirForSourceVersion());
    }

    public void execute() throws UpgradeException, MigrationException {
        this.migrateBinDirectory();
        this.migrateStartupDirectory();
        this.migrateLibDirectory();
        this.migrateConfDirectory();
        this.migrateDeployDirectory();
        this.migrateServerLibDirectory();
        if (this.sourceOperationalMode.equals("STANDALONE") || this.sourceOperationalMode.equals("CLUSTERED_CONSOLE") || this.sourceOperationalMode.equals("CLUSTERED_DUAL")) {
            this.migrateDataDirectory();
        } else {
            log.info("Directory " + LogHelper.getInstance().getCleanPath(this.pingFederateDirectoryInfo.getSourceDataDir()) + " will not be migrated as mode for this node is " + this.sourceOperationalMode);
            this.copyFileFromDataDir("hsmpasswd.txt");
            this.copyFileFromDataDir("pf.jwk");
        }
        this.checkFeatures();
        this.checkWriteUpgradeInfo();
    }

    private void copyFileFromDataDir(String filename) throws UpgradeException {
        File srcFile = new File(this.sourceRootDir + this.pingFederateDirectoryInfo.getRelativeDataDir(), filename);
        if (srcFile.exists()) {
            File destFile = new File(this.destinationRootDir + this.pingFederateDirectoryInfo.getRelativeDataDir(), filename);
            try {
                FilesUtils.copyfile((File)srcFile, (File)destFile);
            }
            catch (IOException e) {
                throw new UpgradeException("Unable to copy " + filename, e);
            }
        }
    }

    private void checkFeatures() {
        new AJPConnectorHandler(this.sourceRootDir).checkFeature();
        new SnmpConfigurationHandler(this.sourceRootDir).checkFeature();
        new LunaSupportHandler(this.sourceRootDir).checkFeature();
        new EmailSettingHandler(this.sourceRootDir).checkFeature();
        DeprecatedServicesHandler deprecatedServiceHandler = new DeprecatedServicesHandler(this.sourceRootDir);
        deprecatedServiceHandler.addService("SsoDirectoryService", "SSO Directory Service");
        deprecatedServiceHandler.addService("ConnectionManagement", "Connection Management Service");
        deprecatedServiceHandler.checkFeature();
    }

    private void migrateBinDirectory() {
        String[] fileExt = new String[]{"properties"};
        File srcBinDir = new File(this.sourceRootDir + this.pingFederateDirectoryInfo.getRelativeBinDir());
        Collection sourceBinPropertyFiles = FileUtils.listFiles((File)srcBinDir, (String[])fileExt, (boolean)false);
        block14: for (File sourceBinPropertyFile : sourceBinPropertyFiles) {
            switch (sourceBinPropertyFile.getName()) {
                case "run.properties": {
                    File destinationFile = new File(this.pingFederateDirectoryInfo.getDestinationRootDir() + this.pingFederateDirectoryInfo.getRelativeBinDir(), sourceBinPropertyFile.getName());
                    this.fileMigrationManager.migrate((FileMigrator)new PropertyFileMigrator(this.makeRunPropertiesPropertyMigrator(destinationFile)), this.pingFederateDirectoryInfo.getRelativeBinDir(), sourceBinPropertyFile.getName(), null);
                    continue block14;
                }
                case "ldap.properties": {
                    PropertyMigrator ldapPropertiesPropertyMigrator = this.makeLdapPropertiesPropertyMigrator();
                    this.fileMigrationManager.migrate((FileMigrator)new PropertyFileMigrator(ldapPropertiesPropertyMigrator, new AdminRolePropertyAppender(AdminRolePropertyName.LDAP_PROPERTIES, this.sourcePFVersion), this.makeAdminRolePropertyRemover(AdminRolePropertyName.LDAP_PROPERTIES)), this.pingFederateDirectoryInfo.getRelativeBinDir(), sourceBinPropertyFile.getName(), null);
                    continue block14;
                }
                case "radius.properties": {
                    PropertyFileMigrator radiusPropertiesPropertyMigrator = this.getPropertyFileMigrator(AdminRolePropertyName.RADIUS_PROPERTIES);
                    this.fileMigrationManager.migrate((FileMigrator)radiusPropertiesPropertyMigrator, this.pingFederateDirectoryInfo.getRelativeBinDir(), sourceBinPropertyFile.getName(), null);
                    continue block14;
                }
                case "cert_auth.properties": {
                    PropertyFileMigrator certPropertiesPropertyMigrator = this.getPropertyFileMigrator(AdminRolePropertyName.CERT_PROPERTIES);
                    this.fileMigrationManager.migrate((FileMigrator)certPropertiesPropertyMigrator, this.pingFederateDirectoryInfo.getRelativeBinDir(), sourceBinPropertyFile.getName(), null);
                    continue block14;
                }
                case "jgroups.properties": {
                    PropertyMigrator jgroupsPropertiesPropertyMigrator = this.makeJGroupsPropertiesPropertyMigrator();
                    this.fileMigrationManager.migrate((FileMigrator)new PropertyFileMigrator(jgroupsPropertiesPropertyMigrator), this.pingFederateDirectoryInfo.getRelativeBinDir(), sourceBinPropertyFile.getName(), null);
                }
            }
            this.fileMigrationManager.migrate((FileMigrator)new PropertyFileMigrator(), this.pingFederateDirectoryInfo.getRelativeBinDir(), sourceBinPropertyFile.getName(), null);
        }
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeBinDir(), "jvm-memory.options", (FileCustomAction)new JvmMemoryOptionsCustomAction(this.destinationPFVersion));
    }

    private PropertyFileMigrator getPropertyFileMigrator(AdminRolePropertyName fileType) {
        AdminRolePropertyMigrator migrator = new AdminRolePropertyMigrator(fileType, this.sourcePFVersion);
        AdminRolePropertyAppender appender = new AdminRolePropertyAppender(fileType, this.sourcePFVersion);
        PropertyRemover remover = this.makeAdminRolePropertyRemover(fileType);
        return new PropertyFileMigrator(migrator, appender, remover);
    }

    private PropertyMigrator makeClusterConfigReplicationPropertyMigrator(final File destinationFile) {
        return new PropertyMigrator(){
            private static final String PUBLISH_REPLICATION_DATA_ON_STARTUP = "publish.replication.data.on.startup";

            public String migrateProperty(String propertyName, String srcValue, String srcDefault, String dstDefault, Properties srcValues, Properties srcDefaults, Properties dstDefaults, String fileName) {
                String result = null;
                if (PUBLISH_REPLICATION_DATA_ON_STARTUP.equals(propertyName) && srcValue == null) {
                    result = "false";
                }
                if (result != null) {
                    log.info("Update " + LogHelper.getInstance().getCleanPath(destinationFile.getPath()) + ". Change property " + propertyName + " from " + LogHelper.getInstance().getValueForLog(propertyName, (Object)dstDefault) + " to " + LogHelper.getInstance().getValueForLog(propertyName, (Object)result) + ".");
                }
                return result;
            }
        };
    }

    private PropertyMigrator makeRunPropertiesPropertyMigrator(final File destinationFile) {
        return new PropertyMigrator(){
            private static final String PF_TLS_CLIENT_PROTOCOLS = "pf.tls.client.protocols";
            private static final String PF_TLS_RUNTIME_SERVER_PROTOCOLS = "pf.tls.runtime.server.protocols";
            private static final String PF_TLS_ADMIN_SERVER_PROTOCOLS = "pf.tls.admin.server.protocols";
            private static final String PF_CLUSTER_ADAPTIVE = "pf.cluster.adaptive";
            private static final String PF_CONSOLE_AUTHENTICATION = "pf.console.authentication";
            private static final String PF_ADMIN_API_AUTHENTICATION = "pf.admin.api.authentication";
            private static final String IGNORE_LINE_BREAKS = "org.apache.xml.security.ignoreLineBreaks";
            private static final String PF_PROVISIONING_MODE = "pf.provisioner.mode";
            private static final String PF_ADMIN_BASEURL = "pf.admin.baseurl";
            private static final String PF_ADMIN_HOSTNAME = "pf.admin.hostname";
            private static final String PF_ADMIN_HTTPS_PORT = "pf.admin.https.port";
            private static final String PF_HSM_MODE = "pf.hsm.mode";
            private static final String PF_RUNTIME_REQUEST_LOG_FORMAT = "jetty.runtime.requestlog.format";
            private static final String PF_ADMIN_REQUEST_LOG_FORMAT = "jetty.admin.requestlog.format";
            private static final String DEPRECATED_PF_ADMIN_REQUEST_LOG_FORMAT = "jetty.requestlog.formatString";
            private boolean isUserWarnedAboutRequestLogMigration = false;

            public String migrateProperty(String propertyName, String srcValue, String srcDefault, String dstDefault, Properties srcValues, Properties srcDefaults, Properties dstDefaults, String fileName) {
                Object result = null;
                switch (propertyName) {
                    case "pf.tls.client.protocols": 
                    case "pf.tls.runtime.server.protocols": 
                    case "pf.tls.admin.server.protocols": {
                        String javaVersion = System.getProperty("java.version");
                        if (javaVersion == null || !javaVersion.startsWith("1.8.") || srcValue != null) break;
                        result = "TLSv1.2";
                        break;
                    }
                    case "pf.cluster.adaptive": 
                    case "org.apache.xml.security.ignoreLineBreaks": {
                        if (srcValue != null) break;
                        result = "false";
                        break;
                    }
                    case "pf.admin.api.authentication": {
                        if (!srcDefaults.containsKey(PF_ADMIN_API_AUTHENTICATION)) {
                            result = srcValues.getProperty(PF_CONSOLE_AUTHENTICATION, "native");
                        }
                        if (!StringUtils.equalsIgnoreCase((String)"cert", (String)srcValue)) break;
                        log.info("Header forwarding configuration for certificate based admin authentication has been moved to 'cert_auth.properties'.");
                        break;
                    }
                    case "pf.console.authentication": {
                        if (!StringUtils.equalsIgnoreCase((String)"cert", (String)srcValue)) break;
                        log.info("Header forwarding configuration for certificate based admin authentication has been moved to 'cert_auth.properties'.");
                        break;
                    }
                    case "pf.admin.baseurl": {
                        String baseurl = srcValues.getProperty(PF_ADMIN_BASEURL);
                        String hostname = srcValues.getProperty(PF_ADMIN_HOSTNAME);
                        String port = srcValues.getProperty(PF_ADMIN_HTTPS_PORT);
                        if (!StringUtils.isBlank((String)baseurl) || !StringUtils.isNotBlank((String)hostname)) break;
                        result = "https://" + hostname + ":" + port;
                        String s = "Upgrade Utility detected that pf.admin.hostname was populated. That property is now deprecated and a new property, pf.admin.baseurl, has been constructed. Please review the new property's value and delete pf.admin.hostname.";
                        log.warn(s);
                        break;
                    }
                    case "pf.provisioner.mode": {
                        try {
                            if (srcValue.equals("OFF") || Version.compare((String)PingFederateMigrator.this.sourcePFVersion, (String)"9.0.0") != 0 && Version.compare((String)PingFederateMigrator.this.sourcePFVersion, (String)"9.0.1") != 0) break;
                            String s = "IMPORTANT: Upgrade Utility detected PingFederate version " + PingFederateMigrator.this.sourcePFVersion + " with Outbound Provisioning enabled. Before running the new installation, the existing provisioning database may need to be cleaned up using the following command:\n\n\tprovmgr --reset-all\n\nFor more information, please consult the PingFederate Upgrade Guide.";
                            log.warn(s);
                        }
                        catch (MigrationException migrationException) {}
                        break;
                    }
                    case "pf.hsm.mode": {
                        if (!PropertyInfo.HSM_MODE.AWSCLOUDHSM.name().equals(srcValue)) break;
                        log.warn("IMPORTANT: Upgrade Utility detected that PingFederate is deployed with AWS Cloud HSM. As of PingFederate 11.2, this requires the usage of AWS Cloud HSM Client SDK JCE provider version 5.5.0 or greater. For more information, please consult the PingFederate Upgrade Guide.");
                        break;
                    }
                    case "jetty.runtime.requestlog.format": 
                    case "jetty.admin.requestlog.format": {
                        this.notifyUserAboutRequestLogMigration(srcValues);
                        if (srcDefault != null && srcDefault.equals(dstDefault)) break;
                        result = dstDefault;
                        break;
                    }
                }
                if (result != null) {
                    log.info("Update " + LogHelper.getInstance().getCleanPath(destinationFile.getPath()) + ". Change property " + propertyName + " from " + LogHelper.getInstance().getValueForLog(propertyName, (Object)dstDefault) + " to " + LogHelper.getInstance().getValueForLog(propertyName, result) + ".");
                }
                return result;
            }

            private void notifyUserAboutRequestLogMigration(Properties srcValues) {
                if (!this.isUserWarnedAboutRequestLogMigration) {
                    try {
                        if (Version.compare((String)PingFederateMigrator.this.sourcePFVersion, (String)PingFederateMigrator.REQUEST_LOG_MIGRATION_SUPPORT_VERSION) < 0) {
                            log.warn("IMPORTANT: Request logging has been updated to use Log4j2 - this allows for more flexible logging customizations. If these features are incompatible with your deployment, legacy behavior can be configured. Please consult the \"HTTP Request Logging\" section of the PingFederate Documentation for more information.");
                            this.isUserWarnedAboutRequestLogMigration = true;
                            if (srcValues.containsKey(DEPRECATED_PF_ADMIN_REQUEST_LOG_FORMAT)) {
                                log.warn("IMPORTANT: The property jetty.requestlog.formatString has been deprecated. Please use jetty.admin.requestlog.format instead.");
                            }
                        }
                    }
                    catch (MigrationException migrationException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private PropertyMigrator makeLdapPropertiesPropertyMigrator() {
        return new PropertyMigrator(){
            private static final String PF_LDAP_VERIFY_HOSTNAME = "ldap.verifyHostname";

            public String migrateProperty(String propertyName, String srcValue, String srcDefault, String dstDefault, Properties srcValues, Properties srcDefaults, Properties dstDefaults, String fileName) {
                String result = null;
                if (PF_LDAP_VERIFY_HOSTNAME.equals(propertyName)) {
                    if (srcValue == null) {
                        result = "false";
                    }
                } else {
                    AdminRolePropertyMigrator migrator = new AdminRolePropertyMigrator(AdminRolePropertyName.LDAP_PROPERTIES, PingFederateMigrator.this.sourcePFVersion);
                    result = migrator.migrateProperty(propertyName, srcValue, srcDefault, dstDefault, srcValues, srcDefaults, dstDefaults, fileName);
                }
                return result;
            }
        };
    }

    private PropertyMigrator makeJGroupsPropertiesPropertyMigrator() {
        return new PropertyMigrator(){
            private static final String RETURN_ENTIRE_CACHE = "pf.cluster.TCPPING.return_entire_cache";

            public String migrateProperty(String propertyName, String srcValue, String srcDefault, String dstDefault, Properties srcValues, Properties srcDefaults, Properties dstDefaults, String fileName) {
                if (RETURN_ENTIRE_CACHE.equals(propertyName) && "true".equals(StringUtils.trim((String)srcValue))) {
                    return "true";
                }
                return null;
            }
        };
    }

    private PropertyRemover makeAdminRolePropertyRemover(final AdminRolePropertyName adminRolePropertyName) {
        return new PropertyRemover(){

            public Set<String> getPropertiesToRemove(Properties sourceProperties, Properties destinationProperties, String fileName) {
                HashSet<String> propertiesToRemove = new HashSet<String>();
                if (!sourceProperties.containsKey(adminRolePropertyName.getAdminRoleGroup())) {
                    propertiesToRemove.add(adminRolePropertyName.getEaRoleGroup());
                    propertiesToRemove.add(adminRolePropertyName.getDcRoleGroup());
                }
                return propertiesToRemove;
            }
        };
    }

    private String getDestinationBinDirectoryPath() {
        return "<destinationPingfederateRootDir>" + File.separator + "bin" + File.separator;
    }

    private void migrateConfDirectory() throws MigrationException {
        if (Version.compare((String)this.sourcePFVersion, (String)"8.0.0") >= 0) {
            this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "log4j2.xml", (FileCustomAction)new Log4j2ConfigFileCustomAction(this.destinationPFVersion));
            this.fileMigrationManager.migrate((FileMigrator)new PropertyFileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "log4j2.db.properties", null);
        } else {
            this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "log4j.xml", (FileCustomAction)new Log4jConfigFileCustomAction(this.sourcePFVersion));
        }
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "log4j-categories.xml", (FileCustomAction)new CopyIfModifiedCustomAction(this.destinationPFVersion));
        this.migrateTemplateDirectory();
        this.migrateVelocityTemplates();
        this.fileMigrationManager.migrate((FileMigrator)new HivemoduleMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "META-INF" + File.separator + "hivemodule.xml", (FileCustomAction)new HivemoduleCustomAction(this.sourcePFVersion));
        this.fileMigrationManager.migrate((FileMigrator)new ConfigStoreFileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "jmx-remote-config.xml", null);
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "tcp.xml", (FileCustomAction)new TcpUdpXmlFileCustomAction(this.sourcePFVersion, this.destinationPFVersion));
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "udp.xml", (FileCustomAction)new TcpUdpXmlFileCustomAction(this.sourcePFVersion, this.destinationPFVersion));
        if (Version.compare((String)this.sourcePFVersion, (String)"8.4.0") < 0) {
            if (Version.compare((String)this.destinationPFVersion, (String)"8.4.0") >= 0) {
                log.info("The HTML format email notification templates have been updated to support localization. If the email notification templates were modified, please update these templates accordingly.");
            } else if (Version.compare((String)this.destinationPFVersion, (String)"8.2.0") >= 0) {
                log.info("The email notification templates in plain text format have been deprecated and replaced with HTML format templates. If the plain text format templates were modified, please update the new templates accordingly.");
            }
        }
        this.migrateLanguagePackFiles();
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfDir(), "pingfederate.lic", (FileCustomAction)new LicenseFileCustomAction(this.destinationPFVersion, this.licenseFileLocation));
        String[] fileExt = new String[]{"conf"};
        File confDir = new File(this.sourceRootDir + this.pingFederateDirectoryInfo.getRelativeConfDir());
        Collection confFiles = FileUtils.listFiles((File)confDir, (String[])fileExt, (boolean)false);
        for (File confFile : confFiles) {
            File destinationFile = new File(this.pingFederateDirectoryInfo.getDestinationRootDir() + this.pingFederateDirectoryInfo.getRelativeConfDir(), confFile.getName());
            PropertyFileMigrator propertyFileMigrator = new PropertyFileMigrator();
            if (confFile.getName().equals("cluster-config-replication.conf")) {
                propertyFileMigrator = new PropertyFileMigrator(this.makeClusterConfigReplicationPropertyMigrator(destinationFile));
            }
            this.fileMigrationManager.migrate((FileMigrator)propertyFileMigrator, this.pingFederateDirectoryInfo.getRelativeConfDir(), confFile.getName(), null);
        }
    }

    private void migrateTemplateDirectory() {
        File sourceRoot = new File(this.pingFederateDirectoryInfo.getSourceRootDir());
        File templateDir = new File(this.pingFederateDirectoryInfo.getSourceTemplateDir());
        File mailNotificationsTemplateDir = new File(this.pingFederateDirectoryInfo.getSourceEmailTemplateDir());
        Collection allDirs = FileUtils.listFilesAndDirs((File)templateDir, (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        allDirs.remove(templateDir);
        allDirs.remove(mailNotificationsTemplateDir);
        ArrayList<File> allNonVelocityTemplates = new ArrayList<File>();
        allDirs.forEach(dir -> allNonVelocityTemplates.addAll(FileUtils.listFiles((File)dir, (IOFileFilter)CanReadFileFilter.CAN_READ, (IOFileFilter)FileFileFilter.INSTANCE)));
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeConfTemplateDir(), "PingConnectIdpAuthnAdapter.form.template.html", null);
        allNonVelocityTemplates.forEach(template -> {
            File destinationFile;
            String relativePath = File.separator + sourceRoot.toURI().relativize(template.getParentFile().toURI()).getPath();
            if (!template.isDirectory() && !(destinationFile = new File(this.pingFederateDirectoryInfo.getDestinationRootDir() + relativePath + File.separator + template.getName())).exists()) {
                this.fileMigrationManager.migrate(new FileMigrator(), relativePath, template.getName(), (FileCustomAction)new TemplateFileCustomAction());
            }
        });
    }

    private void migrateVelocityTemplates() throws MigrationException {
        File sourceRoot = new File(this.pingFederateDirectoryInfo.getSourceRootDir());
        File templateDir = new File(this.pingFederateDirectoryInfo.getSourceTemplateDir());
        Collection allVelocityTemplates = FileUtils.listFiles((File)templateDir, (IOFileFilter)CanReadFileFilter.CAN_READ, (IOFileFilter)FileFileFilter.INSTANCE);
        if (Version.compare((String)this.sourcePFVersion, (String)"8.2.0") >= 0) {
            File mailNotificationsTemplateDir = new File(this.pingFederateDirectoryInfo.getSourceEmailTemplateDir());
            allVelocityTemplates.addAll(FileUtils.listFilesAndDirs((File)mailNotificationsTemplateDir, (IOFileFilter)CanReadFileFilter.CAN_READ, (IOFileFilter)TrueFileFilter.INSTANCE));
        }
        ArrayList<String> renamedTemplates = new ArrayList<String>();
        ArrayList<String> oldTemplates = new ArrayList<String>();
        allVelocityTemplates.forEach(template -> {
            if (!template.isDirectory()) {
                if (template.getName().matches(".*-default-\\d+(\\.\\d+)*.*")) {
                    oldTemplates.add(template.getName());
                }
                String relativePath = File.separator + sourceRoot.toURI().relativize(template.getParentFile().toURI()).getPath();
                this.fileMigrationManager.migrate(new FileMigrator(), relativePath, template.getName(), (FileCustomAction)new VelocityTemplateFileCustomAction(this.destinationPFVersion, renamedTemplates::add));
            }
        });
        oldTemplates.sort(String.CASE_INSENSITIVE_ORDER);
        renamedTemplates.sort(String.CASE_INSENSITIVE_ORDER);
        this.logItemsWithMessage("The following template files were carried over from previous upgrades. They should be merged with the current template files and be removed from the new installation.", oldTemplates);
        this.logItemsWithMessage("We've detected changes in the following template files. We've copied them to the new installation, with their file names and extensions intact. We also renamed the stock version of these files in the new installation by using this naming convention: <template_name>-default-<PF_version>.<extension>. For each of the customized template files, merge your custom changes with new capabilities introduced in its corresponding renamed stock version. Once merged, remove the renamed stock versions.", renamedTemplates);
        List<String> altAuthSourceDependentTemplates = Arrays.asList("html.form.login.template.html", "local.identity.registration.html", "local.identity.profile.html", "alt-authn-source.template.html");
        List updatedTemplates = renamedTemplates.stream().filter(altAuthSourceDependentTemplates::contains).collect(Collectors.toList());
        if (!updatedTemplates.isEmpty() && updatedTemplates.size() < altAuthSourceDependentTemplates.size()) {
            List<String> templatesToCopy = altAuthSourceDependentTemplates.stream().filter(s -> !renamedTemplates.contains(s)).collect(Collectors.toList());
            this.logItemsWithMessage("The following template files are dependent on each other.", altAuthSourceDependentTemplates);
            this.logItemsWithMessage("Since we have detected changes in one or more of these templates, the following templates will also be copied into the new installation.", templatesToCopy);
            for (String templateToCopy : templatesToCopy) {
                Optional<File> templateFile = allVelocityTemplates.stream().filter(template -> template.getName().equals(templateToCopy)).findAny();
                templateFile.ifPresent(template -> {
                    String relativePath = File.separator + sourceRoot.toURI().relativize(template.getParentFile().toURI()).getPath();
                    this.fileMigrationManager.migrate(new FileMigrator(), relativePath, template.getName(), (FileCustomAction)new AltAuthnSourceDependentTemplateFileCustomAction(this.destinationPFVersion));
                });
            }
        }
    }

    private void migrateLanguagePackFiles() {
        String propertiesExt = ".properties";
        String pingfederateMessages = "pingfederate-messages";
        String pingfederateEmailMessages = "pingfederate-email-messages";
        String pingfederateSmslMessages = "pingfederate-sms-messages";
        String pingOneMFAMessages = "pingone-mfa-messages";
        String pingOneRiskManagementMessages = "pingone-risk-management-messages";
        String pingOneProtectMessages = "pingone-protect-messages";
        String pingOneVerifyMessages = "pingone-verify-messages";
        String pingOneDavinciMessages = "pingone-davinci-messages";
        Collection allLanguagePackPropertiesFiles = FileUtils.listFiles((File)new File(this.pingFederateDirectoryInfo.getSourceLanguagePackDir()), (IOFileFilter)new SuffixFileFilter(".properties"), null);
        LinkedList<File> pingfederateMessagesFiles = new LinkedList<File>();
        LinkedList<File> pingfederateEmailMessagesFiles = new LinkedList<File>();
        LinkedList<File> pingfederateSmsMessagesFiles = new LinkedList<File>();
        LinkedList<File> pingOneMFAMessagesFiles = new LinkedList<File>();
        LinkedList<File> pingOneRiskManagementMessagesFiles = new LinkedList<File>();
        LinkedList<File> pingOneProtectMessagesFiles = new LinkedList<File>();
        LinkedList<File> pingOneVerifyMessagesFiles = new LinkedList<File>();
        LinkedList<File> pingOneDavinciMessagesFiles = new LinkedList<File>();
        LinkedList<File> otherPropertiesFiles = new LinkedList<File>();
        for (File file : allLanguagePackPropertiesFiles) {
            if (StringUtils.containsIgnoreCase((String)file.getName(), (String)"pingfederate-messages")) {
                pingfederateMessagesFiles.add(file);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)file.getName(), (String)"pingfederate-email-messages")) {
                pingfederateEmailMessagesFiles.add(file);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)file.getName(), (String)"pingfederate-sms-messages")) {
                pingfederateSmsMessagesFiles.add(file);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)file.getName(), (String)"pingone-mfa-messages")) {
                pingOneMFAMessagesFiles.add(file);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)file.getName(), (String)"pingone-risk-management-messages")) {
                pingOneRiskManagementMessagesFiles.add(file);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)file.getName(), (String)"pingone-protect-messages")) {
                pingOneProtectMessagesFiles.add(file);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)file.getName(), (String)"pingone-verify-messages")) {
                pingOneVerifyMessagesFiles.add(file);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)file.getName(), (String)"pingone-davinci-messages")) {
                pingOneDavinciMessagesFiles.add(file);
                continue;
            }
            otherPropertiesFiles.add(file);
        }
        this.migrateLanguagePackPropertyFile(pingfederateMessagesFiles, "pingfederate-messages.properties", false, "10.3.0");
        this.migrateLanguagePackPropertyFile(pingfederateEmailMessagesFiles, "pingfederate-email-messages.properties", false, "10.3.0");
        this.migrateLanguagePackPropertyFile(pingfederateSmsMessagesFiles, "pingfederate-sms-messages.properties", false, "10.3.0");
        this.migrateLanguagePackPropertyFile(pingOneMFAMessagesFiles, "pingone-mfa-messages.properties", true, "10.3.0");
        this.migrateLanguagePackPropertyFile(pingOneRiskManagementMessagesFiles, "pingone-risk-management-messages.properties", true, "10.3.0");
        this.migrateLanguagePackPropertyFile(pingOneProtectMessagesFiles, "pingone-protect-messages.properties", true, "12.0.0");
        this.migrateLanguagePackPropertyFile(pingOneVerifyMessagesFiles, "pingone-verify-messages.properties", true, "11.1.0");
        this.migrateLanguagePackPropertyFile(pingOneDavinciMessagesFiles, "pingone-davinci-messages.properties", true, "11.2.0");
        for (File propertyFile : otherPropertiesFiles) {
            this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getRelativeLanguagePackDir(), propertyFile.getName(), null);
        }
    }

    private void migrateLanguagePackPropertyFile(List<File> pingfederateMessagesFiles, String defaultFileName, boolean isIkPropertyFile, String versionAddedToPingFederate) {
        pingfederateMessagesFiles = pingfederateMessagesFiles.parallelStream().sorted(this.getLanguagePackPropertiesFileComparator(defaultFileName)).collect(Collectors.toList());
        for (File propertyFile : pingfederateMessagesFiles) {
            PropertyFileMigrator propertyFileMigrator = new PropertyFileMigrator(LANGUAGE_PACK_PROPERTY_FILE_CHARSET, false);
            this.fileMigrationManager.migrate((FileMigrator)propertyFileMigrator, this.pingFederateDirectoryInfo.getRelativeLanguagePackDir(), propertyFile.getName(), (FileCustomAction)(isIkPropertyFile ? new IntegrationKitLanguagePackPropertyFileCustomAction(propertyFileMigrator, defaultFileName, this.sourcePFVersion, versionAddedToPingFederate) : new LanguagePackPropertyFileCustomAction(propertyFileMigrator, defaultFileName, this.sourcePFVersion)));
            Path defaultPropertiesFile = Paths.get(this.pingFederateDirectoryInfo.getReferenceFilesLanguagePackDir(), defaultFileName);
            if (!propertyFileMigrator.hasNewPropertiesAdded() || StringUtils.containsIgnoreCase((String)propertyFile.getName(), (String)"_en") || !this.hasCustomizedPropertyValues(propertyFile, defaultPropertiesFile.toFile())) continue;
            File destinationPropertyFile = new File(this.pingFederateDirectoryInfo.getDestinationLanguagePackDir(), propertyFile.getName());
            log.warn(LogHelper.getInstance().getCleanPath(destinationPropertyFile) + " has newly added properties that may require review.");
        }
    }

    private Comparator<File> getLanguagePackPropertiesFileComparator(String defaultFileName) {
        return (file1, file2) -> {
            if (file1 != null && defaultFileName.equals(file1.getName())) {
                return 1;
            }
            if (file2 != null && defaultFileName.equals(file2.getName())) {
                return -1;
            }
            return 0;
        };
    }

    private void migrateDataDirectory() throws MigrationException {
        DataDirectoryMigrator dataDirectoryMigrator = new DataDirectoryMigrator(this.sourceRootDir, this.destinationRootDir, this.sourcePFVersion, this.destinationPFVersion, this.pingFederateDirectoryInfo, this.fileMigrationManager, this.mode);
        dataDirectoryMigrator.migrateDataDirectory();
    }

    private void migrateLibDirectory() {
        String[] fileExt = new String[]{"jar"};
        File sourceLibDir = new File(this.sourceRootDir + this.pingFederateDirectoryInfo.getRelativeLibDir());
        Collection sourceLibJars = FileUtils.listFiles((File)sourceLibDir, (String[])fileExt, (boolean)false);
        for (File sourceLibJar : sourceLibJars) {
            JettyPatchesCustomAction customAction = null;
            if (sourceLibJar.getName().startsWith("jetty-")) {
                customAction = new JettyPatchesCustomAction(this.mode);
            }
            this.fileMigrationManager.migrate((FileMigrator)new ArchiveFileMigrator(), this.pingFederateDirectoryInfo.getRelativeLibDir(), sourceLibJar.getName(), (FileCustomAction)customAction);
        }
    }

    private void migrateServerLibDirectory() {
        String[] fileExt = new String[]{"jar"};
        File sourceServerLibDir = new File(this.sourceRootDir + this.pingFederateDirectoryInfo.getRelativeServerLibDir());
        Collection sourceServerLibJars = FileUtils.listFiles((File)sourceServerLibDir, (String[])fileExt, (boolean)false);
        for (File sourceServerLibJar : sourceServerLibJars) {
            Object customAction = null;
            if ("salesforce-partner.jar".equals(sourceServerLibJar.getName())) {
                customAction = new SalesforcePartnerApiCustomAction(this.mode);
            } else if (sourceServerLibJar.getName().startsWith("pf-kerberos-token-translator")) {
                customAction = new KerberosTokenTranslatorAction(this.mode);
            } else if (sourceServerLibJar.getName().startsWith("pf-authn-api-sdk")) {
                customAction = new KeepLatestJarCustomAction(this.mode);
            } else if (sourceServerLibJar.getName().startsWith("PingIDRadiusPCV")) {
                customAction = new PingIDPcvLibCustomAction();
            }
            String srcFileName = sourceServerLibJar.getName();
            if (!this.isPatchedServerLibJar(srcFileName)) {
                this.fileMigrationManager.migrate((FileMigrator)new ArchiveFileMigrator(), this.pingFederateDirectoryInfo.getRelativeServerLibDir(), srcFileName, (FileCustomAction)customAction);
                continue;
            }
            log.debug("Found the patch file: " + sourceServerLibDir.getAbsolutePath() + File.separator + srcFileName + "  This file will NOT be migrated.");
        }
    }

    protected boolean isPatchedServerLibJar(String srcFileName) {
        String patchFilePattern = ".*-p[0-9]+.jar";
        String lowerFileName = srcFileName.toLowerCase();
        return lowerFileName.matches(patchFilePattern);
    }

    private void migrateDeployDirectory() {
        File sourceDeployDir = new File(this.sourceRootDir + this.pingFederateDirectoryInfo.getRelativeDeployDir());
        File[] selectedSourceDeployFiles = sourceDeployDir.listFiles(file -> file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".war") || file.getName().endsWith(".xml"));
        assert (selectedSourceDeployFiles != null);
        for (File selectedSourceDeployFile : selectedSourceDeployFiles) {
            String friendlyName;
            String jarName;
            ArchiveFileCustomAction customAction = null;
            if (selectedSourceDeployFile.getName().startsWith("opentoken-adapter")) {
                customAction = new OpenTokenAdapterCustomAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-ldap-java-adapter")) {
                customAction = new LdapAdapterCustomAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-google-quickconnection")) {
                customAction = new GoogleConnectorCustomAction(this.mode, this.pingFederateDirectoryInfo.getReferenceFilesRootDirForConnectors());
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pcv-pone")) {
                customAction = new PingOnePcvCustomAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-kerberos-token-translator")) {
                customAction = new KerberosTokenTranslatorAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-username-token-translator")) {
                customAction = new UsernameTokenProcessorCustomAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-iwa-authn-adapter")) {
                customAction = new IWACustomAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("common-mfa-") || selectedSourceDeployFile.getName().startsWith("gson-") || selectedSourceDeployFile.getName().startsWith("pf-pingid-idp-adapter-") || selectedSourceDeployFile.getName().startsWith("PingIDRadiusPCV-")) {
                customAction = new PingIDRadiusPCVPackageCustomAction(this.mode, selectedSourceDeployFile.getName());
            } else if (selectedSourceDeployFile.getName().startsWith("pf-referenceid-adapter")) {
                customAction = new AgentlessIKCustomAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("x509-certificate-adapter")) {
                customAction = new X509AdapterCustomAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingid-quickconnection")) {
                customAction = new PingIdConnectorKitCustomAction(this.mode);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-p14c-datastore")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-datastore", "PingOne Datastore", "pf-pingone-kits-upgrade", true);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-p14c-pcv")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-pcv", "PingOne PCV", "pf-pingone-kits-upgrade", true);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-p14c-quickconnection")) {
                customAction = new PingOneConnectorKitCustomAction(this.mode, "pf-pingone-quickconnection", "PingOne Connector", "PingOne for Customers Connector");
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-pcv")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-pcv", "PingOne PCV");
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-datastore")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-datastore", "PingOne Datastore");
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-quickconnection")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-quickconnection", "PingOne Connector");
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-mfa-adapter")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-mfa-adapter", "PingOne MFA Adapter");
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-risk-management-adapter")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-risk-management-adapter", "PingOne Risk Management Adapter");
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-verify-adapter")) {
                jarName = "pf-pingone-verify-adapter";
                friendlyName = "PingOne Verify Adapter";
                customAction = new GenericBundledKitCustomAction(this.mode, jarName, friendlyName);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-protect-adapter")) {
                jarName = "pf-pingone-protect-adapter";
                friendlyName = "PingOne Protect Adapter";
                customAction = new GenericBundledKitCustomAction(this.mode, jarName, friendlyName);
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-davinci-adapter")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-davinci-adapter", "PingOne DaVinci IdP Adapter");
            } else if (selectedSourceDeployFile.getName().startsWith("pf-pingone-fraud-adapter")) {
                customAction = new PingOneServiceKitCustomAction(this.mode, "pf-pingone-fraud-adapter", "PingOne Fraud IdP Adapter");
            }
            this.fileMigrationManager.migrate((FileMigrator)new ArchiveFileMigrator(), this.pingFederateDirectoryInfo.getRelativeDeployDir(), selectedSourceDeployFile.getName(), (FileCustomAction)customAction);
        }
        this.removeObsoleteFiles();
    }

    private void migrateStartupDirectory() {
        File sourceStartupDir = new File(this.sourceRootDir + this.pingFederateDirectoryInfo.getRelativeStartupDir());
        File[] selectedSourceFiles = sourceStartupDir.listFiles(file -> file.getName().endsWith(".jar") || file.getName().endsWith(".so") || file.getName().endsWith(".dll"));
        if (selectedSourceFiles == null) {
            return;
        }
        for (File selectedSourceFile : selectedSourceFiles) {
            this.fileMigrationManager.migrate((FileMigrator)new ArchiveFileMigrator(), this.pingFederateDirectoryInfo.getRelativeStartupDir(), selectedSourceFile.getName(), null);
        }
    }

    private void removeObsoleteFiles() {
        File pfDeployDir = new File(this.destinationRootDir + this.pingFederateDirectoryInfo.getRelativeDeployDir());
        this.removeObsoletePingIdFiles(pfDeployDir);
        this.removeObsoleteJars(pfDeployDir);
    }

    private void removeObsoletePingIdFiles(File pfDeployDir) {
        Collection jarFiles = FileUtils.listFiles((File)pfDeployDir, (IOFileFilter)new WildcardFileFilter("pf-pingid-idp-adapter-*.jar"), null);
        if (jarFiles.size() == 1) {
            File destinationJar = (File)jarFiles.iterator().next();
            String version = this.extractVersion(destinationJar.getName());
            try {
                Version destVersion = new Version(version);
                Version oneDotFour = new Version("1.4.0");
                if (oneDotFour.compareTo(destVersion) <= 0) {
                    Collection mfaFiles;
                    Collection gsonFiles = FileUtils.listFiles((File)pfDeployDir, (IOFileFilter)new WildcardFileFilter("gson-*.jar"), null);
                    if (gsonFiles.size() == 1) {
                        File gsonJar = (File)gsonFiles.iterator().next();
                        FilesUtils.deleteFile((File)gsonJar);
                    }
                    if ((mfaFiles = FileUtils.listFiles((File)pfDeployDir, (IOFileFilter)new WildcardFileFilter("common-mfa-*.jar"), null)).size() == 1) {
                        File mfaJar = (File)mfaFiles.iterator().next();
                        FilesUtils.deleteFile((File)mfaJar);
                    }
                }
            }
            catch (MigrationException e) {
                log.warn("Unable to determine the version for " + destinationJar.getName());
            }
        }
    }

    private void removeObsoleteJars(File pfDeployDir) {
        Collection ldapExtAttrFiles = FileUtils.listFiles((File)pfDeployDir, (IOFileFilter)new WildcardFileFilter("LDAPExtendedAttributesPCV-*.jar"), null);
        if (ldapExtAttrFiles.size() == 1) {
            File ldapExtAttrJar = (File)ldapExtAttrFiles.iterator().next();
            FilesUtils.deleteFile((File)ldapExtAttrJar);
        }
    }

    private String extractVersion(String version) {
        String versionNumberAndSuffix = StringUtils.substringAfterLast((String)version, (String)"-");
        Object versionNumber = StringUtils.substringBeforeLast((String)versionNumberAndSuffix, (String)".");
        if (StringUtils.countMatches((String)versionNumber, (String)".") == 1) {
            versionNumber = (String)versionNumber + ".0";
        }
        return versionNumber;
    }

    private boolean hasCustomizedPropertyValues(File propertiesFile, File defaultPropertiesFile) {
        Properties defaultSourceProperties;
        Properties sourceProperties;
        block5: {
            block4: {
                sourceProperties = new Properties();
                defaultSourceProperties = new Properties();
                try {
                    sourceProperties = this.loadProperties(propertiesFile, LANGUAGE_PACK_PROPERTY_FILE_CHARSET);
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("There was a problem loading the source properties at " + LogHelper.getInstance().getCleanPath(propertiesFile));
                    log.debug(e.getLocalizedMessage());
                }
            }
            try {
                defaultSourceProperties = this.loadProperties(defaultPropertiesFile, LANGUAGE_PACK_PROPERTY_FILE_CHARSET);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("There was a problem loading the default properties at " + LogHelper.getInstance().getCleanPath(defaultPropertiesFile));
                log.debug(e.getLocalizedMessage());
            }
        }
        return this.hasPropertyDifferences(sourceProperties, defaultSourceProperties);
    }

    boolean hasPropertyDifferences(Properties sourceProperties, Properties defaultSourceProperties) {
        for (String sourcePropertyKey : sourceProperties.stringPropertyNames()) {
            String defaultSourcePropertyValue;
            String sourcePropertyValue = sourceProperties.getProperty(sourcePropertyKey);
            if (StringUtils.equals((String)sourcePropertyValue, (String)(defaultSourcePropertyValue = defaultSourceProperties.getProperty(sourcePropertyKey)))) continue;
            return true;
        }
        return false;
    }

    private Properties loadProperties(File propertiesFile, Charset propertiesCharset) throws IOException {
        Properties props = new Properties();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(propertiesFile), propertiesCharset));){
            props.load(br);
        }
        return props;
    }

    private void logItemsWithMessage(String message, Collection<String> items) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            sb.append(System.getProperty("line.separator") + item);
        }
        if (!items.isEmpty()) {
            log.warn(message + sb);
        }
    }

    private void checkWriteUpgradeInfo() throws UpgradeException {
        if (this.sourceOperationalMode.equals("CLUSTERED_CONSOLE") || this.sourceOperationalMode.equals("CLUSTERED_DUAL")) {
            String UPGRADE_INFO_FILENAME = "org.sourceid.util.UpgradeInfo.xml";
            try {
                File upgradeInfoFile = new File(this.destinationRootDir + this.pingFederateDirectoryInfo.getRelativeInstanceDataDir(), "org.sourceid.util.UpgradeInfo.xml");
                FileUtils.write((File)upgradeInfoFile, (CharSequence)this.getUpgradeInfo());
            }
            catch (IOException e) {
                throw new UpgradeException("Unable to create org.sourceid.util.UpgradeInfo.xml", e);
            }
        }
    }

    private String getUpgradeInfo() {
        String LINE_BREAK = System.getProperty("line.separator", "\n");
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append(LINE_BREAK).append("<c:config xmlns:c=\"http://www.sourceid.org/2004/05/config\">").append(LINE_BREAK).append("    <c:item name=\"PostUpgradeProcessingRequired\">true</c:item>").append(LINE_BREAK).append("</c:config>");
        return sb.toString();
    }

    private static class PFWebAppProviderConfigSourceMissingCustomAction
    extends ConfigStoreFileCustomAction {
        private PFWebAppProviderConfigSourceMissingCustomAction() {
        }

        private String getModifiedConfigContent(File defaultConfigFile) throws IOException {
            try (FileInputStream inputStream = FileUtils.openInputStream((File)defaultConfigFile);){
                String string = String.join((CharSequence)"\n", IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.trim().equals("<!--") && !line.trim().equals("-->")).collect(Collectors.toList()));
                return string;
            }
        }

        private void writeModifiedConfig(File modifiedConfigFile, String modifiedConfigContent) throws IOException {
            try (FileOutputStream outputStream = FileUtils.openOutputStream((File)modifiedConfigFile);){
                IOUtils.write((String)modifiedConfigContent, (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            }
        }

        public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
            String modifiedConfigContent;
            File defaultConfigFile = new File(destinationFileParentDir, fileName);
            if (!defaultConfigFile.exists()) {
                return true;
            }
            try {
                modifiedConfigContent = this.getModifiedConfigContent(defaultConfigFile);
            }
            catch (IOException exception) {
                throw new FileCustomActionException(String.format("Source file does not exist, but unable to read the default configuration file %s due to I/O error - %s", LogHelper.getInstance().getCleanPath(defaultConfigFile), exception.getMessage()));
            }
            if (!defaultConfigFile.delete()) {
                throw new FileCustomActionException(String.format("Source file does not exist, but unable to delete the default configuration file %s", LogHelper.getInstance().getCleanPath(defaultConfigFile)));
            }
            File modifiedConfigFile = new File(destinationFileParentDir, fileName);
            try {
                this.writeModifiedConfig(modifiedConfigFile, modifiedConfigContent);
            }
            catch (IOException exception) {
                throw new FileCustomActionException(String.format("Source file does not exist, but unable to write the modified configuration file %s to restore original configuration due to I/O error - %s", LogHelper.getInstance().getCleanPath(defaultConfigFile), exception.getMessage()));
            }
            return true;
        }
    }
}

