/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.featurehandler;

import com.pingidentity.common.upgrade.PingFederateDirectoryInfo;
import com.pingidentity.pingfederate.migration.featurehandler.FeatureHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AJPConnectorHandler
implements FeatureHandler {
    private static final Logger log = LogManager.getLogger(AJPConnectorHandler.class);
    public final String fileName = "jetty-runtime.xml";
    private final String sourceRootDir;

    public AJPConnectorHandler(String sourceRootDir) {
        this.sourceRootDir = sourceRootDir;
    }

    @Override
    public void checkFeature() {
        File file = new File(this.getParentPath(), "jetty-runtime.xml");
        if (file.exists()) {
            try {
                for (String line : IOUtils.readLines((InputStream)FileUtils.openInputStream((File)file), (Charset)Charsets.UTF_8)) {
                    if (!line.contains("org.eclipse.jetty.ajp.Ajp13SocketConnector")) continue;
                    log.warn("AJP is no longer supported. Please refer to the Administrator's Manual under \"Setting System Options\" for instructions.");
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getParentPath() {
        PingFederateDirectoryInfo pingFederateDirectoryInfo = PingFederateDirectoryInfo.getInstance();
        return this.sourceRootDir + pingFederateDirectoryInfo.getRelativeEtcDir();
    }
}

