/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.featurehandler;

import com.pingidentity.pingfederate.migration.featurehandler.XmlConfigFeatureHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DeprecatedServicesHandler
extends XmlConfigFeatureHandler {
    private static final Logger log = LogManager.getLogger(DeprecatedServicesHandler.class);
    public final String filePath = "/server/default/data/config-store/org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl.xml";
    private final Map<String, String> deprecatedServices = new HashMap<String, String>();

    public DeprecatedServicesHandler(String sourceRootDir) {
        this.fullFilePath = sourceRootDir + "/server/default/data/config-store/org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl.xml";
    }

    @Override
    public void checkFeature() {
        try {
            for (Map.Entry<String, String> service : this.deprecatedServices.entrySet()) {
                String serviceXPath = "/config/map[@name='" + service.getKey() + "']/item[@name='isActive']";
                Node serviceNode = this.query(serviceXPath);
                if (serviceNode == null || !"true".equalsIgnoreCase(serviceNode.getTextContent())) continue;
                log.warn(service.getValue() + " is no longer supported by PingFederate as it has been deprecated.");
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
            // empty catch block
        }
    }

    public void addService(String serviceConfigName, String serviceFullName) {
        this.deprecatedServices.putIfAbsent(serviceConfigName, serviceFullName);
    }
}

