/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.featurehandler;

import com.pingidentity.pingfederate.migration.featurehandler.XmlConfigFeatureHandler;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LunaSupportHandler
extends XmlConfigFeatureHandler {
    private static final Logger log = LogManager.getLogger(LunaSupportHandler.class);
    public final String filePath = "/server/default/conf/META-INF/hivemodule.xml";

    public LunaSupportHandler(String sourceRootDir) {
        this.fullFilePath = sourceRootDir + "/server/default/conf/META-INF/hivemodule.xml";
    }

    @Override
    public void checkFeature() {
        try {
            Node lunaJCENode4 = this.query("/module/service-point[@id='JCEManager']/invoke-factory/construct[@class='com.pingidentity.crypto.LunaJCEManager']");
            Node lunaCertServiceNode4 = this.query("/module/service-point[@id='CertificateService']/invoke-factory/construct[@class='com.pingidentity.crypto.LunaCertificateServiceImpl']");
            Node lunaJCENode5 = this.query("/module/service-point[@id='JCEManager']/invoke-factory/construct[@class='com.pingidentity.crypto.LunaJCEManager5']");
            Node lunaCertServiceNode5 = this.query("/module/service-point[@id='CertificateService']/invoke-factory/construct[@class='com.pingidentity.crypto.LunaCertificateServiceImpl5']");
            if (lunaJCENode5 != null || lunaCertServiceNode5 != null || lunaJCENode4 != null || lunaCertServiceNode4 != null) {
                log.warn("Luna 4 and 5 are no longer supported. Please refer to the Administrator's Manual under \"Supported hardware security modules\" for instructions.");
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
            // empty catch block
        }
    }
}

