/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file;

import com.pingidentity.common.upgrade.FileMigrator;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class ArchiveFileMigrator
extends FileMigrator {
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public boolean isDefaultFile(File sourceDefaultFileParentDir, String fileName) throws FileMigrationException {
        boolean defaultFile = false;
        File defaultFilesList = new File(sourceDefaultFileParentDir, "file-list.txt");
        if (!defaultFilesList.exists()) {
            return false;
        }
        try (LineIterator lineIterator = FileUtils.lineIterator((File)defaultFilesList);){
            while (lineIterator.hasNext()) {
                String line = lineIterator.nextLine();
                if (!line.contains(fileName)) continue;
                defaultFile = true;
                break;
            }
        }
        catch (IOException e) {
            throw new FileMigrationException("Unable to check if file is default", (Throwable)e);
        }
        return defaultFile;
    }

    public boolean isFilesEqual(File sourceFile, File destinationFile) {
        return sourceFile.getName().equals(destinationFile.getName());
    }
}

