/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file;

import com.pingidentity.common.upgrade.FileMigrator;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingcommons.upgrade.file.CustomActionListener;
import com.pingidentity.pingcommons.upgrade.file.FileMigrationException;
import com.pingidentity.pingcommons.upgrade.file.PropertyAppender;
import com.pingidentity.pingcommons.upgrade.file.PropertyMigrator;
import com.pingidentity.pingcommons.upgrade.file.PropertyRemover;
import com.pingidentity.pingfederate.migration.file.custom.SinglePropertyCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.propertyfile.LanguagePackPropertyFileCustomAction;
import com.pingidentity.pingfederate.migration.file.custom.propertyfile.PropertyFileCustomAction;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyFileMigrator
extends FileMigrator {
    private static final Logger log = LogManager.getLogger(PropertyFileMigrator.class);
    private boolean hasNewPropertiesAdded;
    private com.pingidentity.pingcommons.upgrade.file.LogHelper logHelper = new com.pingidentity.pingcommons.upgrade.file.LogHelper(){

        public String getCleanPath(String path) {
            return LogHelper.getInstance().getCleanPath(path);
        }
    };
    private com.pingidentity.pingcommons.upgrade.file.PropertyFileMigrator migrator = new com.pingidentity.pingcommons.upgrade.file.PropertyFileMigrator(this.logHelper);

    public PropertyFileMigrator() {
    }

    public PropertyFileMigrator(PropertyMigrator propertyMigrator) {
        if (propertyMigrator != null) {
            this.migrator.setCustomMigrator(propertyMigrator);
        }
    }

    public PropertyFileMigrator(PropertyMigrator propertyMigrator, PropertyAppender propertyAppender, PropertyRemover propertyRemover) {
        if (propertyMigrator != null) {
            this.migrator.setCustomMigrator(propertyMigrator);
        }
        if (propertyAppender != null) {
            this.migrator.setPropertyAppender(propertyAppender);
        }
        if (propertyRemover != null) {
            this.migrator.setPropertyRemover(propertyRemover);
        }
    }

    public PropertyFileMigrator(Charset propertyFileCharset, boolean hidePasswordProperties) {
        if (propertyFileCharset != null) {
            this.migrator = new com.pingidentity.pingcommons.upgrade.file.PropertyFileMigrator(this.logHelper, propertyFileCharset);
        }
        this.migrator.setHidePasswordProperties(hidePasswordProperties);
    }

    public boolean hasNewPropertiesAdded() {
        return this.hasNewPropertiesAdded;
    }

    public void merge(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) {
        this.migrate(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, fileName, null);
    }

    public void merge(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName, String defaultFileName) {
        this.migrate(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, defaultFileName, null);
    }

    public void customMigrate(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName, FileCustomAction customAction) throws FileCustomActionException {
        if (customAction instanceof PropertyFileCustomAction) {
            this.migrate(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, fileName, (PropertyFileCustomAction)customAction);
        } else if (customAction instanceof LanguagePackPropertyFileCustomAction) {
            customAction.performMigration(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName);
        } else {
            throw new IllegalArgumentException("Unsupported custom action for " + PropertyFileMigrator.class.getName());
        }
    }

    private void migrate(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName, String defaultFileName, final PropertyFileCustomAction propertyFileCustomAction) {
        CustomActionListener customActionListener = new CustomActionListener(){

            public String handleCustomAction(String propertyName, String sourcePropertyValue, String destPropertyValue, Map<Object, Object> allSourceValues) {
                SinglePropertyCustomAction customAction;
                if (propertyFileCustomAction != null && (customAction = propertyFileCustomAction.getCustomActionForProperty(propertyName)) != null) {
                    return customAction.getValue(sourcePropertyValue, destPropertyValue, allSourceValues);
                }
                return null;
            }
        };
        this.migrator.registerCustomActionListener(customActionListener);
        Path defaultSrcFile = Paths.get(sourceDefaultFileParentDir.getAbsolutePath(), defaultFileName);
        Path srcFile = Paths.get(sourceFileParentDir.getAbsolutePath(), fileName);
        Path destFile = Paths.get(destinationFileParentDir.getAbsolutePath(), fileName);
        try {
            this.migrator.migrate(srcFile, destFile, defaultSrcFile);
            if (this.migrator.hasNewPropertiesAdded()) {
                this.hasNewPropertiesAdded = true;
            }
        }
        catch (FileMigrationException e) {
            log.error("Unable to upgrade property file: ", (Throwable)e);
        }
    }
}

