/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CopyIfModifiedCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(CopyIfModifiedCustomAction.class);
    protected String destinationVersion;
    private Consumer<String> renamedFiles;

    public CopyIfModifiedCustomAction(String destinationVersion) {
        this.destinationVersion = destinationVersion;
    }

    public CopyIfModifiedCustomAction(String destinationVersion, Consumer<String> renamedFiles) {
        this.destinationVersion = destinationVersion;
        this.renamedFiles = renamedFiles;
    }

    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        block6: {
            File sourceConfig = new File(sourceFileParentDir, fileName);
            File defaultSourceConfig = new File(sourceDefaultFileParentDir, fileName);
            File destinationConfig = new File(destinationFileParentDir, fileName);
            try {
                if (FileUtils.contentEquals((File)sourceConfig, (File)defaultSourceConfig)) break block6;
                Object extension = FilenameUtils.getExtension((String)fileName);
                if (!((String)extension).isEmpty()) {
                    extension = "." + (String)extension;
                }
                File renamedDestinationConfig = new File(destinationFileParentDir, FilenameUtils.removeExtension((String)fileName) + "-default-" + this.destinationVersion + (String)extension);
                try {
                    FileUtils.moveFile((File)destinationConfig, (File)renamedDestinationConfig);
                    if (this.renamedFiles != null) {
                        this.renamedFiles.accept(fileName);
                    }
                    log.info("Rename " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()) + " to " + LogHelper.getInstance().getCleanPath(renamedDestinationConfig.getPath()));
                }
                catch (IOException e) {
                    log.error("Unable to rename " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()) + " to " + LogHelper.getInstance().getCleanPath(renamedDestinationConfig.getPath()), (Throwable)e);
                }
                FilesUtils.copyfile((File)sourceConfig, (File)destinationConfig);
            }
            catch (IOException e) {
                throw new FileCustomActionException("Unable to migrate " + LogHelper.getInstance().getCleanPath(sourceConfig.getPath()), (Throwable)e);
            }
        }
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        return false;
    }

    public boolean copyIfSourceDefaultMissing() {
        return false;
    }
}

