/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingfederate.migration.util.hivemodule.HivemoduleConfGenerationHelper;
import com.pingidentity.pingfederate.migration.util.hivemodule.HivemoduleXmlMigrationHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HivemoduleCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(HivemoduleCustomAction.class);
    private static final String SERVICE_POINTS_CONF = "service-points.conf";
    private final LogHelper logHelper = LogHelper.getInstance();
    private final String sourceVersion;

    public HivemoduleCustomAction(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File sourceHivemoduleXmlFile = new File(sourceFileParentDir, fileName);
        if (!sourceHivemoduleXmlFile.exists()) {
            return;
        }
        HivemoduleXmlMigrationHelper hivemoduleHelper = new HivemoduleXmlMigrationHelper(this.sourceVersion);
        File sourceServicePointsConfFile = new File(sourceFileParentDir + File.separator + SERVICE_POINTS_CONF);
        if (sourceServicePointsConfFile.exists()) {
            this.migrateHivemoduleXml(hivemoduleHelper, sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName);
        } else {
            HivemoduleConfGenerationHelper hivemoduleConfGenerationHelper = new HivemoduleConfGenerationHelper();
            Properties defaultServicePointsMap = this.getDefaultServicePointMap(destinationFileParentDir);
            Map<String, String> sourceServicePointsMap = hivemoduleConfGenerationHelper.getSourceServicePointsMap(sourceHivemoduleXmlFile, fileName);
            if (sourceServicePointsMap.isEmpty()) {
                throw new FileCustomActionException("Unable to parse " + this.logHelper.getCleanPath(sourceHivemoduleXmlFile.getPath()));
            }
            if (defaultServicePointsMap.keySet().containsAll(sourceServicePointsMap.keySet())) {
                log.warn("Start generating service-points.conf from " + this.logHelper.getCleanPath(sourceHivemoduleXmlFile.getPath()) + "...");
                HivemoduleConfGenerationHelper.generateServicePointsConf(destinationFileParentDir, sourceServicePointsMap);
                log.warn("service-points.conf generation is completed. Please use service-points.conf to specify the implementation classes for of core PingFederate services. ");
            } else {
                log.warn("Customized " + this.logHelper.getCleanPath(new File(sourceFileParentDir, fileName)) + " was detected. Will migrate hivemodule.xml instead of generating service-points.conf.");
                this.migrateHivemoduleXml(hivemoduleHelper, sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName);
            }
        }
    }

    private void migrateHivemoduleXml(HivemoduleXmlMigrationHelper hivemoduleHelper, File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        try {
            hivemoduleHelper.migrateHivemoduleXml(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName);
        }
        catch (Exception e) {
            throw new FileCustomActionException("Failed to generate " + this.logHelper.getCleanPath(new File(destinationFileParentDir, fileName)), (Throwable)e);
        }
    }

    private Properties getDefaultServicePointMap(File destinationFileParentDir) throws FileCustomActionException {
        Properties properties = new Properties();
        File servicePointFile = new File(destinationFileParentDir, SERVICE_POINTS_CONF);
        if (!servicePointFile.exists()) {
            log.error("Failed to find " + this.logHelper.getCleanPath(destinationFileParentDir.getAbsolutePath()));
            return properties;
        }
        try (InputStream inputStream = Files.newInputStream(servicePointFile.toPath(), new OpenOption[0]);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new FileCustomActionException("Failed to load " + this.logHelper.getCleanPath(servicePointFile.getAbsolutePath()), (Throwable)e);
        }
        return properties;
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        return false;
    }

    public boolean copyIfSourceDefaultMissing() {
        return false;
    }
}

