/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.common.Util;
import org.sourceid.util.license.PingLicense;

public class LicenseFileCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(LicenseFileCustomAction.class);
    private String destinationPFVersion;
    private String licenseFileLocation;

    public LicenseFileCustomAction(String destinationPFVersion, String licenseFileLocation) {
        this.destinationPFVersion = destinationPFVersion;
        this.licenseFileLocation = licenseFileLocation;
    }

    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File sourcePfLicenseFile;
        if (StringUtils.isNotEmpty((String)this.licenseFileLocation)) {
            sourcePfLicenseFile = new File(this.licenseFileLocation);
            if (log.isDebugEnabled()) {
                log.debug("Using provided license location: " + this.licenseFileLocation);
            }
        } else {
            sourcePfLicenseFile = new File(sourceFileParentDir, fileName);
            if (log.isDebugEnabled()) {
                log.debug("No specific license file location provided. Will try to migrate license from source PingFederate: " + sourcePfLicenseFile);
            }
        }
        if (StringUtils.isEmpty((String)fileName)) {
            log.warn("Invalid license filename for license migration.");
            return;
        }
        File destinationPfLicenseFile = new File(destinationFileParentDir, fileName);
        if (destinationFileParentDir.exists()) {
            PingLicense pingLicense = new PingLicense(sourcePfLicenseFile.toPath(), false);
            boolean isInvalidForDestinationVersion = !pingLicense.isValid() || !LicenseFileCustomAction.isLicenseValidForPfVersion(this.destinationPFVersion, pingLicense) || pingLicense.isExpired() || pingLicense.areAllConnectionGroupExpiredWithRespectTo(new Date());
            boolean forceLicenceMigration = pingLicense.isBridgeMode();
            if (isInvalidForDestinationVersion && !forceLicenceMigration) {
                log.warn("License not valid for destination version of PingFederate. Skipping license migration.");
                return;
            }
            try {
                FilesUtils.copyfile((File)sourcePfLicenseFile, (File)destinationPfLicenseFile);
                log.info("License copied to destination PingFederate:" + Util.LINE_BREAK + pingLicense.getLogLicenseLoadedMsg());
            }
            catch (IOException e) {
                log.error(String.format("Unable to migrate license file from source location \"%s\" to destination directory \"%s\".", sourcePfLicenseFile, destinationFileParentDir), (Throwable)e);
            }
        } else {
            log.warn("Directory for license not found at destination PingFederate location: " + destinationFileParentDir);
        }
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) {
        return false;
    }

    public boolean copyIfSourceDefaultMissing() {
        return false;
    }

    static boolean isLicenseValidForPfVersion(String pingFedVersion, PingLicense pingLicense) {
        if (StringUtils.isEmpty((String)pingFedVersion)) {
            return false;
        }
        String[] version = pingFedVersion.split("\\.");
        if (version.length < 2) {
            return false;
        }
        return pingLicense.isValidMajorVersion(Integer.parseInt(version[0])) && pingLicense.isValidMinorVersion(Integer.parseInt(version[1]));
    }
}

