/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleConnectorCustomAction
extends ArchiveFileCustomAction {
    private static final Logger log = LogManager.getLogger(GoogleConnectorCustomAction.class);
    private String connectorsDirPath;

    public GoogleConnectorCustomAction(String mode, String connectorsDirPath) {
        super(mode);
        this.connectorsDirPath = connectorsDirPath;
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        try {
            if (fileName.startsWith("pf-google-quickconnection-1.")) {
                String google201FileName = "pf-google-quickconnection-2.0.1.jar";
                log.info("Google connector " + fileName + " is not compatible with this version of PingFederate.  Upgrading to " + google201FileName);
                File googleConnector201 = new File(this.connectorsDirPath + File.separator + "pf-google-connector-2.0.1", google201FileName);
                FilesUtils.copyfile((File)googleConnector201, (File)new File(destinationFileParentDir, google201FileName));
            } else {
                FilesUtils.copyfile((File)new File(sourceFileParentDir, fileName), (File)new File(destinationFileParentDir, fileName));
            }
        }
        catch (IOException ioe) {
            throw new FileCustomActionException("Error while migrating " + sourceDefaultFileParentDir + File.separator + fileName, (Throwable)ioe);
        }
    }
}

