/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import com.pingidentity.pingfederate.migration.file.ArchiveFileMigrator;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JettyPatchesCustomAction
extends ArchiveFileCustomAction {
    private static final Logger log = LogManager.getLogger(JettyPatchesCustomAction.class);

    public JettyPatchesCustomAction(String mode) {
        super(mode);
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        if (!this.fileExistsInSourceVersion(sourceDefaultFileParentDir, fileName)) {
            log.info("Found manually patched Jetty jar: " + fileName + ". This jar will NOT be migrated.");
        } else {
            log.debug("File not migrated. " + LogHelper.getInstance().getCleanPath(fileName) + " is no longer needed.");
        }
    }

    private boolean fileExistsInSourceVersion(File sourceFolder, String fileName) {
        try {
            return new ArchiveFileMigrator().isDefaultFile(sourceFolder, fileName);
        }
        catch (FileMigrationException e) {
            log.debug("Could not determine if " + fileName + " was part of the original source. Defaulting to false.");
            return false;
        }
    }
}

