/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.pingfederate.migration.file.custom.kit.BundledKitCustomAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenTokenAdapterCustomAction
extends BundledKitCustomAction {
    private static final Logger log = LogManager.getLogger(OpenTokenAdapterCustomAction.class);
    private static String TWO_FIVE_ONE = "2.5.1";

    public OpenTokenAdapterCustomAction(String mode) {
        super(mode);
        this.friendlyName = "OpenToken Adapter";
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        block8: {
            boolean isInteractiveMode = "-c".equals(this.getMode());
            try {
                File sourceOpenTokenJar = new File(sourceFileParentDir, fileName);
                Collection opentokenJars = FileUtils.listFiles((File)destinationFileParentDir, (IOFileFilter)new WildcardFileFilter("opentoken-adapter*.jar"), null);
                if (opentokenJars.size() == 0) {
                    log.warn("Expected opentoken-adapter jar in " + destinationFileParentDir + " but file does not exist.");
                    FilesUtils.copyfile((File)sourceOpenTokenJar, (File)new File(destinationFileParentDir, fileName));
                    break block8;
                }
                if (opentokenJars.size() == 1) {
                    File destinationOpenTokenJar = (File)opentokenJars.iterator().next();
                    if (!fileName.equals(destinationOpenTokenJar.getName())) {
                        boolean isVersionLessThanTwoFiveOne = this.isVersionLessThanTwoFiveOne(fileName);
                        boolean destinationNewer = this.isDestinationVersionNewer(sourceOpenTokenJar.getName(), destinationOpenTokenJar.getName());
                        boolean useSourceJar = true;
                        if (isInteractiveMode && (isVersionLessThanTwoFiveOne || destinationNewer)) {
                            useSourceJar = this.promptForUpgradeDecision(isVersionLessThanTwoFiveOne ? "opentoken-adapter-upgrade-less-than-2.5.1" : "opentoken-adapter-upgrade", fileName, destinationOpenTokenJar.getName());
                        }
                        if (useSourceJar) {
                            if (!isInteractiveMode && destinationNewer && isVersionLessThanTwoFiveOne) {
                                log.warn("A more recent version of the OpenToken adapter is distributed with PingFederate. The newer version contains important security updates, and upgrading to 2.5.1 or greater is recommended.");
                            }
                            FilesUtils.deleteFile((File)destinationOpenTokenJar);
                            FilesUtils.copyfile((File)sourceOpenTokenJar, (File)new File(destinationFileParentDir, fileName));
                        }
                    }
                    break block8;
                }
                throw new FileCustomActionException("More than one opentoken-adapter jar was found in " + destinationFileParentDir + ". Unable to migrate " + sourceOpenTokenJar.getPath());
            }
            catch (IOException ioe) {
                throw new FileCustomActionException("Unable to migrate " + sourceDefaultFileParentDir + File.separator + fileName, (Throwable)ioe);
            }
        }
    }

    protected boolean isVersionLessThanTwoFiveOne(String fileName) throws FileCustomActionException {
        boolean isVersionLessThanTwoFiveOne = false;
        try {
            Version twoFiveOne = new Version(TWO_FIVE_ONE);
            Version sourceVersion = new Version(this.extractVersion(fileName));
            isVersionLessThanTwoFiveOne = sourceVersion.compareTo(twoFiveOne) < 0;
        }
        catch (MigrationException e) {
            throw new FileCustomActionException((Throwable)e);
        }
        return isVersionLessThanTwoFiveOne;
    }

    @Override
    protected String extractVersion(String version) {
        if (StringUtils.countMatches((String)version, (String)"-") == 2) {
            String versionNumberAndSuffix = StringUtils.substringAfterLast((String)version, (String)"-");
            Object versionNumber = StringUtils.substringBeforeLast((String)versionNumberAndSuffix, (String)".");
            if (StringUtils.countMatches((String)versionNumber, (String)".") == 1) {
                versionNumber = (String)versionNumber + ".0";
            }
            return versionNumber;
        }
        String nameAndVersionNumber = StringUtils.substringBeforeLast((String)version, (String)"-");
        String versionNumber = StringUtils.substringAfterLast((String)nameAndVersionNumber, (String)"-");
        return versionNumber;
    }
}

