/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.pingfederate.migration.file.custom.kit.BundledKitCustomAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PingIDRadiusPCVPackageCustomAction
extends BundledKitCustomAction {
    private static String PING_ID_INTEGRATION_VERSION_NUMER_PATTERN = "[-][[0-9]*[.]]*+(jar)";
    private static final Logger log = LogManager.getLogger(PingIDRadiusPCVPackageCustomAction.class);

    public PingIDRadiusPCVPackageCustomAction(String mode) {
        super(mode);
    }

    public PingIDRadiusPCVPackageCustomAction(String mode, String fileName) {
        super(mode);
        if (fileName.startsWith("pf-pingid-idp-adapter")) {
            this.friendlyName = "PingID IdP Adapter";
        } else if (fileName.startsWith("PingIDRadiusPCV")) {
            this.friendlyName = "PingID Radius PCV";
        }
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        block8: {
            String commonFileName = this.getFileNameWithoutVersion(fileName, sourceDefaultFileParentDir);
            try {
                File sourceFile = new File(sourceFileParentDir, fileName);
                Collection jarFiles = FileUtils.listFiles((File)destinationFileParentDir, (IOFileFilter)new WildcardFileFilter(commonFileName + "*.jar"), null);
                if (jarFiles.size() == 0) {
                    Version sourceVersion;
                    Version oneDotFour;
                    boolean copyFiles = true;
                    if ("common-mfa".equals(commonFileName) && (oneDotFour = new Version("1.4.0")).compareTo(sourceVersion = new Version(this.extractVersion(fileName))) <= 0) {
                        copyFiles = false;
                        log.warn("The " + commonFileName + " jar is no longer required since PingID 1.4.");
                    }
                    if (copyFiles) {
                        log.warn("Expected " + commonFileName + " jar in " + destinationFileParentDir + " but file does not exist.");
                        FilesUtils.copyfile((File)sourceFile, (File)new File(destinationFileParentDir, fileName));
                    }
                    break block8;
                }
                if (jarFiles.size() == 1 && ("PingIDRadiusPCV".equals(commonFileName) || "pf-pingid-idp-adapter".equals(commonFileName))) {
                    boolean isInteractiveMode = "-c".equals(this.getMode());
                    File destinationJar = (File)jarFiles.iterator().next();
                    boolean useSourceJar = true;
                    if (this.isDestinationVersionNewer(sourceFile.getName(), destinationJar.getName()) && isInteractiveMode) {
                        useSourceJar = this.promptForUpgradeDecision(commonFileName + "-upgrade", sourceFile.getName(), destinationJar.getName());
                    }
                    if (useSourceJar) {
                        FilesUtils.deleteFile((File)destinationJar);
                        FilesUtils.copyfile((File)sourceFile, (File)new File(destinationFileParentDir, fileName));
                    }
                    break block8;
                }
                throw new FileCustomActionException("More than one jar was found in " + destinationFileParentDir + ". Unable to migrate " + sourceDefaultFileParentDir + File.separator + fileName);
            }
            catch (MigrationException | IOException e) {
                throw new FileCustomActionException("Unable to migrate " + sourceDefaultFileParentDir + File.separator + fileName, e);
            }
        }
    }

    public String getFileNameWithoutVersion(String fileName, File sourceDefaultFileParentDir) throws FileCustomActionException {
        String[] splitNames = fileName.split(PING_ID_INTEGRATION_VERSION_NUMER_PATTERN);
        if (splitNames != null) {
            return splitNames[0];
        }
        throw new FileCustomActionException("Unable to migrate " + sourceDefaultFileParentDir + File.separator + fileName + ". Could not match the expected file versioning pattern.");
    }
}

