/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.kit;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BundledKitCustomAction
extends ArchiveFileCustomAction {
    protected String jarName;
    protected String promptMessageId;
    protected String friendlyName;
    private static final Logger log = LogManager.getLogger(BundledKitCustomAction.class);

    public BundledKitCustomAction(String mode) {
        super(mode);
    }

    public BundledKitCustomAction(String mode, String jarName, String promptMessageId, String friendlyName) {
        super(mode);
        this.jarName = jarName;
        this.promptMessageId = promptMessageId;
        this.friendlyName = friendlyName;
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        block7: {
            boolean isInteractiveMode = "-c".equals(this.getMode());
            try {
                File sourceFile = new File(sourceFileParentDir, fileName);
                Collection destinationJars = FileUtils.listFiles((File)destinationFileParentDir, (IOFileFilter)new WildcardFileFilter(this.jarName + "*.jar"), null);
                if (destinationJars.size() == 0) {
                    log.warn("Expected " + this.jarName + " jar in " + destinationFileParentDir + " but file does not exist.");
                    FilesUtils.copyfile((File)sourceFile, (File)new File(destinationFileParentDir, fileName));
                    break block7;
                }
                if (destinationJars.size() == 1) {
                    String destinationFileName;
                    File destinationJar = (File)destinationJars.iterator().next();
                    String sourceFileName = sourceFile.getName();
                    if (!sourceFileName.equals(destinationFileName = destinationJar.getName())) {
                        boolean useSourceJar = true;
                        if (isInteractiveMode && this.isAllowReplace(sourceFile, destinationJar)) {
                            useSourceJar = this.promptForUpgradeDecision(this.promptMessageId, sourceFileName, destinationFileName, this.friendlyName);
                        }
                        if (useSourceJar) {
                            FilesUtils.deleteFile((File)destinationJar);
                            FilesUtils.copyfile((File)sourceFile, (File)new File(destinationFileParentDir, fileName));
                        }
                    }
                    break block7;
                }
                throw new FileCustomActionException("More than one " + this.jarName + " jar was found in " + destinationFileParentDir + ". Unable to migrate " + sourceFile.getPath());
            }
            catch (FileCustomActionException | IOException e) {
                throw new FileCustomActionException("Unable to migrate " + sourceDefaultFileParentDir + File.separator + fileName, e);
            }
        }
    }

    protected boolean isAllowReplace(File sourceFile, File destinationJar) throws FileCustomActionException {
        return this.isDestinationVersionNewer(sourceFile.getName(), destinationJar.getName());
    }

    protected String extractVersion(String fileName) {
        String versionNumberAndSuffix = StringUtils.substringAfterLast((String)fileName, (String)"-");
        Object versionNumber = StringUtils.substringBeforeLast((String)versionNumberAndSuffix, (String)".");
        if (StringUtils.countMatches((String)versionNumber, (String)".") == 1) {
            versionNumber = (String)versionNumber + ".0";
        }
        return versionNumber;
    }

    protected boolean isDestinationVersionNewer(String sourceFileName, String destinationFilename) throws FileCustomActionException {
        boolean newer = false;
        try {
            Version sourceVersion = new Version(this.extractVersion(sourceFileName));
            Version destinationVersion = new Version(this.extractVersion(destinationFilename));
            newer = destinationVersion.compareTo(sourceVersion) > 0;
        }
        catch (MigrationException e) {
            throw new FileCustomActionException((Throwable)e);
        }
        return newer;
    }

    protected boolean promptForUpgradeDecision(String promptMessageId, String ... messageParams) {
        String sourceVersion = this.extractVersion(messageParams[0]);
        String destinationVersion = this.extractVersion(messageParams[1]);
        String userResponse = this.promptUser(promptMessageId, messageParams);
        boolean useSourceJar = true;
        if (StringUtils.isNotBlank((String)userResponse) && userResponse.equalsIgnoreCase("y")) {
            useSourceJar = false;
        }
        this.logUpgradeDecision(useSourceJar, sourceVersion, destinationVersion);
        return useSourceJar;
    }

    protected void logUpgradeDecision(boolean useSource, String sourceVersion, String destinationVersion) {
        if (useSource) {
            log.info("Administrator opted to not upgrade the " + this.friendlyName + ". Will continue to use version " + sourceVersion);
        } else {
            log.info("Administrator opted to upgrade the " + this.friendlyName + ". Upgrading from version " + sourceVersion + " to version " + destinationVersion);
        }
    }
}

