/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.propertyfile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.pingfederate.migration.file.PropertyFileMigrator;
import com.pingidentity.pingfederate.migration.file.custom.propertyfile.LanguagePackPropertyFileCustomAction;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegrationKitLanguagePackPropertyFileCustomAction
extends LanguagePackPropertyFileCustomAction {
    private static final Logger log = LogManager.getLogger(IntegrationKitLanguagePackPropertyFileCustomAction.class);
    private final String versionAddedToPingFederate;

    public IntegrationKitLanguagePackPropertyFileCustomAction(PropertyFileMigrator propertyFileMigrator, String defaultFileName, String sourcePFVersion, String versionAddedToPingFederate) {
        super(propertyFileMigrator, defaultFileName, sourcePFVersion);
        this.versionAddedToPingFederate = versionAddedToPingFederate;
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File sourceFile = new File(sourceFileParentDir, fileName);
        File destinationFile = new File(destinationFileParentDir, fileName);
        try {
            if (sourceFile.exists()) {
                if (this.getPropertyFileMigrator().isDefaultFile(sourceDefaultFileParentDir, this.getDefaultFileName())) {
                    if (!destinationFile.exists()) {
                        String msg = String.format("Expected %s in %s but file does not exist.", this.getDefaultFileName(), destinationFileParentDir);
                        log.warn(msg);
                        this.copySourceFileToDestination(destinationFileParentDir, sourceFile);
                    }
                    if (!this.getPropertyFileMigrator().isFilesEqual(sourceFile, destinationFile)) {
                        this.getPropertyFileMigrator().merge(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, this.getDefaultFileName());
                    }
                } else if (Version.compare((String)this.getSourcePFVersion(), (String)this.versionAddedToPingFederate) > 0) {
                    log.warn("File not migrated. " + LogHelper.getInstance().getCleanPath(sourceFile) + " is not a recognized PingFederate language pack file.");
                } else if (!destinationFile.exists()) {
                    this.copySourceFileToDestination(destinationFileParentDir, sourceFile);
                    File sourceDefaultFile = new File(sourceDefaultFileParentDir, this.getDefaultFileName());
                    if (sourceDefaultFile.exists()) {
                        this.getPropertyFileMigrator().merge(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, this.getDefaultFileName());
                    } else {
                        this.getPropertyFileMigrator().merge(sourceFileParentDir, destinationFileParentDir, destinationFileParentDir, fileName, this.getDefaultFileName());
                    }
                } else if (!this.getPropertyFileMigrator().isFilesEqual(sourceFile, destinationFile)) {
                    this.getPropertyFileMigrator().merge(sourceFileParentDir, destinationFileParentDir, destinationFileParentDir, fileName, this.getDefaultFileName());
                }
            }
        }
        catch (FileMigrationException | MigrationException e) {
            log.error("Unable to migrate file " + LogHelper.getInstance().getCleanPath(destinationFile), e);
        }
    }

    private void copySourceFileToDestination(File destinationFileParentDir, File sourceFile) {
        File destinationBaseFile = new File(destinationFileParentDir, this.getDefaultFileName());
        try {
            FilesUtils.copyfile((File)sourceFile, (File)destinationBaseFile);
        }
        catch (IOException e) {
            String msg = String.format("Unable to copy file %s to %s", LogHelper.getInstance().getCleanPath(sourceFile), LogHelper.getInstance().getCleanPath(destinationBaseFile));
            log.error(msg, (Throwable)e);
        }
    }
}

