/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.util;

import com.pingidentity.pingfederate.migration.util.Closer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleFileUtil {
    private static Logger log = LogManager.getLogger(SimpleFileUtil.class);
    public static final String LINE_BREAK = System.getProperty("line.separator", "\n");

    public static void writeFileSilent(File file, byte[] content) {
        try {
            SimpleFileUtil.writeFile(file, content);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] content) throws IOException {
        File parentFile = (file = file.getCanonicalFile()).getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Cannot create parent folder: " + parentFile.getAbsolutePath());
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Cannot create file: " + file.getAbsolutePath());
            }
            if (!file.isDirectory() && content != null && content.length > 0) {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(content);
            }
        }
        finally {
            Closer.close(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        FileReader inStream = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            inStream = new FileReader(file);
            BufferedReader buffedIn = new BufferedReader(inStream);
            while ((line = buffedIn.readLine()) != null) {
                sb.append(line).append(LINE_BREAK);
            }
        }
        catch (Throwable throwable) {
            Closer.close(inStream);
            throw throwable;
        }
        Closer.close(inStream);
        return sb.toString();
    }

    public static String readFileToStringSilent(File file) {
        try {
            return SimpleFileUtil.readFileToString(file);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return "";
        }
    }

    public static void deleteFile(String directory, String filename) {
        File f = new File(directory, filename);
        if (f.exists()) {
            if (f.delete()) {
                log.info("deleted file: " + f.getAbsolutePath());
            } else {
                log.info("Cannot delete file: " + f.getAbsolutePath());
            }
        } else {
            log.info("file " + f.getAbsolutePath() + " does not exist. Skipping.");
        }
    }

    public static void renameWithDateExt(File file) {
        String formatPattern = "MM-dd-yyyy.kk.mm.ss";
        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        String dateStr = format.format(new Date());
        File newName = new File(file.getAbsolutePath() + "." + dateStr);
        if (!file.renameTo(newName)) {
            log.info("Cannot rename file " + file.getAbsolutePath() + " to " + newName.getAbsolutePath());
        }
    }

    public static void deleteDirectoryFiles(String dirname) {
        SimpleFileUtil.deleteDirectoryFiles(dirname, false, null);
    }

    public static void deleteDirectoryFiles(String dirname, boolean deleteDirectory) {
        SimpleFileUtil.deleteDirectoryFiles(dirname, deleteDirectory, null);
    }

    public static void deleteDirectoryFiles(String dirname, boolean deleteDirectory, List<String> exceptions) {
        File clearDir = new File(dirname);
        if (clearDir.exists()) {
            boolean directoryContainsExceptions = false;
            String[] farr = clearDir.list();
            if (farr != null) {
                for (String aFarr : farr) {
                    File tmp = new File(clearDir, aFarr);
                    if (exceptions != null && exceptions.contains(tmp.getAbsolutePath())) {
                        directoryContainsExceptions = true;
                        continue;
                    }
                    log.info("deleting file: " + tmp.getAbsolutePath() + " " + aFarr);
                    if (tmp.isDirectory()) {
                        SimpleFileUtil.deleteDirectoryFiles(tmp.getAbsolutePath(), true, exceptions);
                        continue;
                    }
                    if (tmp.delete()) {
                        log.info("deleted file: " + tmp.getAbsolutePath());
                        continue;
                    }
                    log.info("Cannot delete file: " + tmp.getAbsolutePath());
                }
            }
            if (deleteDirectory && !directoryContainsExceptions) {
                if (clearDir.delete()) {
                    log.info("deleted directory: " + clearDir.getAbsolutePath());
                } else {
                    log.info("Cannot delete directory: " + clearDir.getAbsolutePath());
                }
            }
        }
    }

    public static File createTempDirectory(String prefix) throws IOException {
        return SimpleFileUtil.createTempDirectory(prefix, null, null);
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return SimpleFileUtil.createTempDirectory(prefix, suffix, null);
    }

    public static File createTempDirectory(String prefix, String suffix, File parent) throws IOException {
        File tempDir = File.createTempFile(prefix, suffix, parent);
        if (!tempDir.delete()) {
            throw new IOException("Cannot delete temp file: " + tempDir.getAbsolutePath());
        }
        if (!tempDir.mkdir()) {
            throw new IOException("Cannot create temp directory: " + tempDir.getAbsolutePath());
        }
        return tempDir;
    }
}

