/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.util.hivemodule;

import com.pingidentity.common.upgrade.exception.FileMigrationException;
import com.pingidentity.pingfederate.migration.util.hivemodule.HivemoduleHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.pingidentity.utils.HivemoduleGenerator;

public class HivemoduleXmlMigrationHelper
extends HivemoduleHelper {
    private static final String SERVICE_POINTS_CONF = "service-points.conf";
    private static final Logger log = LogManager.getLogger(HivemoduleXmlMigrationHelper.class);

    public HivemoduleXmlMigrationHelper(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public void migrateHivemoduleXml(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String filename) throws FileMigrationException {
        XmlObject sourceHivemoduleXMLXmlDoc;
        File sourceHivemodule = new File(sourceFileParentDir, filename);
        try {
            sourceHivemoduleXMLXmlDoc = XmlObject.Factory.parse((File)sourceHivemodule);
        }
        catch (Exception e) {
            throw new FileMigrationException("Unable to parse " + this.logHelper.getCleanPath(sourceHivemodule.getPath()), (Throwable)e);
        }
        Map<String, XmlObject> sourceServicePointsMap = HivemoduleXmlMigrationHelper.buildServicePointMapFromHivemoduleXML(sourceHivemoduleXMLXmlDoc);
        if (sourceServicePointsMap.isEmpty()) {
            throw new FileMigrationException("Invalid hivemodule.xml.  Services not found in " + this.logHelper.getCleanPath(sourceHivemodule.getPath()));
        }
        this.logDeprecatedServiceUsageMessages(sourceServicePointsMap);
        XmlObject destinationHivemoduleXmlDoc = null;
        File destinationHivemodule = new File(destinationFileParentDir, filename);
        try {
            HivemoduleGenerator.generateHivemoduleWithTemplate((File)destinationHivemodule, (File)new File(destinationFileParentDir, SERVICE_POINTS_CONF));
            destinationHivemoduleXmlDoc = XmlObject.Factory.parse((File)destinationHivemodule);
        }
        catch (Exception e) {
            throw new FileMigrationException("Unable to parse " + this.logHelper.getCleanPath(destinationHivemodule.getPath()), (Throwable)e);
        }
        Map<String, XmlObject> destinationServicePointsMap = HivemoduleXmlMigrationHelper.buildServicePointMapFromHivemoduleXML(destinationHivemoduleXmlDoc);
        if (destinationServicePointsMap.isEmpty()) {
            throw new FileMigrationException("Invalid hivemodule.xml.  Services not found in " + this.logHelper.getCleanPath(destinationHivemodule.getPath()));
        }
        File sourceDefaultHivemodule = new File(sourceDefaultFileParentDir, filename);
        try {
            XmlObject sourceDefaultHivemoduleXmlDoc;
            Map<String, XmlObject> sourceDefaultServicePointsMap;
            if (!sourceDefaultHivemodule.exists()) {
                HivemoduleGenerator.generateHivemoduleWithTemplate((File)sourceDefaultHivemodule, (File)new File(sourceDefaultFileParentDir, SERVICE_POINTS_CONF));
            }
            if ((sourceDefaultServicePointsMap = HivemoduleXmlMigrationHelper.buildServicePointMapFromHivemoduleXML(sourceDefaultHivemoduleXmlDoc = XmlObject.Factory.parse((File)sourceDefaultHivemodule))).isEmpty()) {
                throw new FileMigrationException("Invalid hivemodule.xml.  Services not found in " + this.logHelper.getCleanPath(sourceDefaultHivemodule.getPath()));
            }
            this.migrationHelper(destinationHivemoduleXmlDoc, sourceServicePointsMap, sourceDefaultServicePointsMap, sourceHivemodule, destinationHivemodule);
        }
        catch (Exception e) {
            throw new FileMigrationException("Unable to parse " + this.logHelper.getCleanPath(sourceDefaultHivemodule.getPath()), (Throwable)e);
        }
    }

    public void migrationHelper(XmlObject destinationHivemoduleXmlDoc, Map<String, XmlObject> sourceServicePointsMap, Map<String, XmlObject> sourceDefaultServicePointsMap, File sourceHivemodule, File destinationHivemodule) throws FileMigrationException {
        boolean destUpdated = false;
        XmlCursor destinationCurser = destinationHivemoduleXmlDoc.newCursor();
        do {
            destinationCurser.toNextToken();
            if (!destinationCurser.isStart() || !destinationCurser.getName().getLocalPart().equals("service-point")) continue;
            XmlObject destServicePoint = destinationCurser.getObject();
            String destServicePointId = HivemoduleXmlMigrationHelper.getServicePointIdFromXML(destServicePoint);
            XmlObject sourceServicePoint = sourceServicePointsMap.get(destServicePointId);
            XmlObject sourceDefaultServicePoint = sourceDefaultServicePointsMap.get(destServicePointId);
            String sourceClassName = null;
            String sourceDefaultClassName = null;
            String destinationClassName = HivemoduleXmlMigrationHelper.getClassFromServicePoint(destServicePoint);
            String sourceInterfaceName = null;
            String destinationInterfaceName = this.getInterfaceFromServicePoint(destServicePoint);
            if (sourceServicePoint != null) {
                sourceClassName = HivemoduleXmlMigrationHelper.getClassFromServicePoint(sourceServicePoint);
                sourceInterfaceName = this.getInterfaceFromServicePoint(sourceServicePoint);
            }
            if (sourceDefaultServicePoint != null) {
                sourceDefaultClassName = HivemoduleXmlMigrationHelper.getClassFromServicePoint(sourceDefaultServicePoint);
            }
            String customActionResult = this.servicePointCustomAction(destServicePointId);
            String customInterfaceResult = this.servicePointCustomInterface(destServicePointId, sourceInterfaceName, destinationInterfaceName, sourceClassName, destinationClassName);
            if (customInterfaceResult != null) {
                if (this.setInterfaceInServicePoint(destServicePoint, customInterfaceResult)) {
                    log.info("Update " + this.logHelper.getCleanPath(destinationHivemodule.getPath()) + ". Not changing interface for service " + destServicePointId + " to " + destinationInterfaceName + " from " + sourceInterfaceName + ".");
                } else {
                    log.error("Service definition not migrated: " + this.logHelper.getCleanPath(sourceHivemodule.getPath()) + ". Unable to change interface for service " + destServicePointId + " from " + destinationInterfaceName + " to " + customInterfaceResult + ".");
                }
            }
            if (customActionResult != null) {
                if (StringUtils.equals((String)destinationClassName, (String)customActionResult)) continue;
                if (this.setClassInServicePoint(destServicePoint, customActionResult)) {
                    destUpdated = true;
                    log.info("Update " + this.logHelper.getCleanPath(destinationHivemodule.getPath()) + ".  Change class for service " + destServicePointId + " from " + destinationClassName + " to " + customActionResult + ".");
                    continue;
                }
                log.error("Service definition not migrated: " + this.logHelper.getCleanPath(sourceHivemodule.getPath()) + ". Unable to change class for service " + destServicePointId + " from " + destinationClassName + " to " + customActionResult + ".");
                continue;
            }
            if (sourceServicePoint == null) continue;
            if (sourceClassName == null || sourceDefaultClassName == null || destinationClassName == null) {
                log.error("Service definition not migrated: " + this.logHelper.getCleanPath(sourceHivemodule.getPath()) + ". Unable to migrate class for service " + destServicePointId + ".");
                log.debug("[sourceClassName=" + sourceClassName + "][sourceDefaultClassName=" + sourceDefaultClassName + "][destinationClassName=" + destinationClassName + "]");
                continue;
            }
            if (!sourceClassName.equals(destinationClassName)) {
                if (this.setClassInServicePoint(destServicePoint, sourceClassName)) {
                    destUpdated = true;
                    if (sourceClassName.equals(sourceDefaultClassName)) {
                        log.info("New Default in " + this.logHelper.getCleanPath(destinationHivemodule.getPath()) + ". The default class for service " + destServicePointId + " was changed from " + this.logHelper.getValueForLog(destServicePointId, (Object)sourceDefaultClassName) + " to " + this.logHelper.getValueForLog(destServicePointId, (Object)destinationClassName) + ".");
                        continue;
                    }
                    log.info("Update " + this.logHelper.getCleanPath(destinationHivemodule.getPath()) + ".  Change class for service " + destServicePointId + " from " + destinationClassName + " to " + sourceClassName + ".");
                    continue;
                }
                log.error("Service definition not migrated: " + this.logHelper.getCleanPath(sourceHivemodule.getPath()) + ". Unable to migrate value for service " + destServicePointId + ".");
                continue;
            }
            log.debug("Service definition not migrated: " + this.logHelper.getCleanPath(sourceHivemodule) + ".  Defined class has not changed for service " + destServicePointId);
        } while (destinationCurser.hasNextToken());
        if (destUpdated) {
            try {
                destinationHivemoduleXmlDoc.save(destinationHivemodule);
                String destinationHivemoduleFileString = FileUtils.readFileToString((File)destinationHivemodule);
                if (destinationHivemoduleFileString.startsWith("<?xml")) {
                    int indexOfModule = destinationHivemoduleFileString.indexOf("<module");
                    destinationHivemoduleFileString = destinationHivemoduleFileString.substring(indexOfModule);
                    FileUtils.writeStringToFile((File)destinationHivemodule, (String)destinationHivemoduleFileString, (Charset)null);
                }
            }
            catch (IOException e) {
                throw new FileMigrationException("Error saving " + this.logHelper.getCleanPath(destinationHivemodule.getPath()), (Throwable)e);
            }
        }
    }

    private void logDeprecatedServiceUsageMessages(Map<String, XmlObject> sourceServicePointsMap) {
        String clazz;
        XmlObject interRequestStateMgmt = sourceServicePointsMap.get("InterRequestStateMgmt");
        if (interRequestStateMgmt != null && "org.sourceid.saml20.service.impl.cookie.InterReqStateMgmtCookieImpl".equals(clazz = HivemoduleXmlMigrationHelper.getClassFromServicePoint(interRequestStateMgmt))) {
            log.warn("Cookie based \"Inter-Request State-Management\" (org.sourceid.saml20.service.impl.cookie.InterReqStateMgmtCookieImpl) has been deprecated as of PingFederate 9.2 and may be removed in future releases. It is recommended to use the Inter-Request State-Management proxy implementation (org.sourceid.saml20.service.impl.proxy.InterRequestStateMgmtProxy) instead.");
        }
    }
}

