/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.bcfips;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HybridSecureRandom {
    private static final Logger logger = LoggerFactory.getLogger(HybridSecureRandom.class);

    private HybridSecureRandom() {
    }

    public static void install(SecureRandom secureRandom) {
        CryptoServicesRegistrar.setSecureRandom((SecureRandom)secureRandom);
    }

    public static void installDefault() {
        HybridSecureRandom.install(new Builder().build());
    }

    private static byte[] generatePersonalizationString(Instant currentTime) {
        return Arrays.concatenate((byte[])Pack.longToBigEndian((long)Thread.currentThread().getId()), (byte[])Pack.longToBigEndian((long)currentTime.toEpochMilli()));
    }

    private static class HybridEntropySource
    extends SecureRandom {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private volatile Instant lastReseedTime;
        private final FipsSecureRandom drbg;
        private final int reseedSamples;
        private final Duration reseedInterval;
        private final Supplier<Instant> timeSupplier;
        private final SecureRandom baseRandom;

        HybridEntropySource(int reseedSamples, Duration reseedInterval, SecureRandom baseRandom, Supplier<Instant> timeSupplier) {
            super(null, new HybridEntropyProvider());
            this.reseedSamples = reseedSamples;
            this.reseedInterval = reseedInterval;
            this.baseRandom = baseRandom;
            this.timeSupplier = timeSupplier;
            this.lastReseedTime = timeSupplier.get();
            this.drbg = FipsDRBG.SHA512.fromEntropySource(bitsRequired -> new SignallingEntropySource(bitsRequired)).setPersonalizationString(Strings.toByteArray((String)"Ping Identity Hybrid Entropy Source")).build(baseRandom.generateSeed(32), false, null);
        }

        @Override
        public void setSeed(byte[] seed) {
            if (this.drbg != null) {
                this.drbg.setSeed(seed);
            }
        }

        @Override
        public void setSeed(long seed) {
            if (this.drbg != null) {
                this.drbg.setSeed(seed);
            }
        }

        @Override
        public byte[] generateSeed(int numBytes) {
            byte[] data = new byte[numBytes];
            if (this.samples.getAndIncrement() > this.reseedSamples && this.timeSupplier.get().isAfter(this.lastReseedTime.plus(this.reseedInterval)) && this.seedAvailable.getAndSet(false)) {
                this.samples.set(0);
                this.lastReseedTime = this.timeSupplier.get();
                this.drbg.reseed();
                if (logger.isTraceEnabled()) {
                    logger.trace("DRBG chain reseeded");
                }
            }
            this.drbg.nextBytes(data);
            return data;
        }

        private class SignallingEntropySource
        implements EntropySource {
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);
            private final Executor entropyGatheringExecutor = Executors.newSingleThreadExecutor(runnable -> {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(true);
                return thread;
            });

            SignallingEntropySource(int bitsRequired) {
                this.byteLength = (bitsRequired + 7) / 8;
            }

            public boolean isPredictionResistant() {
                return true;
            }

            public byte[] getEntropy() {
                byte[] seed = this.entropy.getAndSet(null);
                if (seed == null || seed.length != this.byteLength) {
                    seed = HybridEntropySource.this.baseRandom.generateSeed(this.byteLength);
                } else {
                    this.scheduled.set(false);
                }
                if (!this.scheduled.getAndSet(true)) {
                    this.entropyGatheringExecutor.execute(new EntropyGatherer(this.byteLength));
                }
                return seed;
            }

            public int entropySize() {
                return this.byteLength * 8;
            }

            private class EntropyGatherer
            implements Runnable {
                private final int numBytes;

                EntropyGatherer(int numBytes) {
                    this.numBytes = numBytes;
                }

                @Override
                public void run() {
                    SignallingEntropySource.this.entropy.set(HybridEntropySource.this.baseRandom.generateSeed(this.numBytes));
                    HybridEntropySource.this.seedAvailable.set(true);
                }
            }
        }
    }

    private static class HybridEntropyProvider
    extends Provider {
        protected HybridEntropyProvider() {
            super("PIHEP", 1.0, "Ping Identity Hybrid Entropy Provider");
        }
    }

    public static class Builder {
        protected int securityStrengthBits = 256;
        protected int reseedSamples = 20;
        protected Duration reseedInterval = Duration.ofMinutes(5L);
        protected Supplier<Instant> timeSupplier = () -> Instant.ofEpochMilli(System.currentTimeMillis());
        protected SecureRandom baseRandom;

        public Builder securityStrengthBits(int bits) {
            this.securityStrengthBits = bits;
            return this;
        }

        public Builder reseedSamples(int samples) {
            this.reseedSamples = samples;
            return this;
        }

        public Builder reseedInterval(Duration interval) {
            this.reseedInterval = interval;
            return this;
        }

        Builder timeSupplier(Supplier<Instant> timeSupplier) {
            this.timeSupplier = timeSupplier;
            return this;
        }

        Builder baseRandom(SecureRandom baseRandom) {
            this.baseRandom = baseRandom;
            return this;
        }

        public SecureRandom build() {
            if (this.baseRandom == null) {
                try {
                    this.baseRandom = SecureRandom.getInstanceStrong();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("No strong SecureRandom is available", e);
                }
            }
            HybridEntropySource hybridEntropySource = new HybridEntropySource(this.reseedSamples, this.reseedInterval, this.baseRandom, this.timeSupplier);
            return FipsDRBG.SHA512.fromEntropySource((SecureRandom)hybridEntropySource, true).setPersonalizationString(HybridSecureRandom.generatePersonalizationString(this.timeSupplier.get())).build(((SecureRandom)hybridEntropySource).generateSeed(this.securityStrengthBits / 16 + 1), true, Strings.toByteArray((String)"Ping Identity Hybrid Secure Random"));
        }
    }
}

