/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.bcfips;

import com.pingidentity.pingcommons.bcfips.ImportExportException;
import com.pingidentity.pingcommons.bcfips.KeyPair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.bouncycastle.util.encoders.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PemImportUtil {
    private static final Logger logger = LoggerFactory.getLogger(PemImportUtil.class);
    public static final String X509_TYPE = "X.509";
    private static final Provider bouncyCastleFipsProvider = new BouncyCastleFipsProvider();
    private static final String PRIVATE_KEY_PATTERN = "-----BEGIN ENCRYPTED PRIVATE KEY.*END ENCRYPTED PRIVATE KEY-----";

    private PemImportUtil() {
    }

    public static KeyPair getKeyPair(String password, byte[] fileData) throws ImportExportException {
        List<X509Certificate> certs;
        PrivateKey privateKey;
        String pemEncodedFileData = new String(fileData, StandardCharsets.UTF_8);
        String privateKeySection = PemImportUtil.getPrivateKeySection(pemEncodedFileData);
        if (privateKeySection.isEmpty()) {
            throw new ImportExportException("Invalid PEM file format. Missing encrypted private key.");
        }
        String certificatesSection = PemImportUtil.getCertificatesSection(pemEncodedFileData);
        if (certificatesSection.isEmpty()) {
            throw new ImportExportException("Invalid PEM file format. Missing certificate(s).");
        }
        try {
            privateKey = PemImportUtil.readEncryptedKey(password.toCharArray(), privateKeySection);
        }
        catch (DecoderException e) {
            throw new ImportExportException("Failed to decode private key.", e);
        }
        catch (IOException | PKCSException e) {
            throw new ImportExportException("Failed to construct a private key.", e);
        }
        catch (FipsUnapprovedOperationError e) {
            throw new ImportExportException("Error occurred importing PEM-encoded key: " + e.getMessage(), e);
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(certificatesSection.getBytes(StandardCharsets.UTF_8));){
            certs = PemImportUtil.getCerts(in);
        }
        catch (ClassCastException e) {
            throw new ImportExportException("Invalid PEM file format.", e);
        }
        catch (IOException | CertificateException e) {
            throw new ImportExportException("Failed to construct the certificate list.", e);
        }
        return new KeyPair(privateKey, certs);
    }

    protected static String getCertificatesSection(String pemEncodedFileData) {
        String fileDataRemovedPrivateKey = Pattern.compile(PRIVATE_KEY_PATTERN, 32).matcher(pemEncodedFileData).replaceFirst("");
        String certificatesSection = "";
        String searchString = "-----BEGIN CERTIFICATE-----";
        if (fileDataRemovedPrivateKey.contains(searchString)) {
            certificatesSection = fileDataRemovedPrivateKey;
        }
        return certificatesSection;
    }

    protected static String getPrivateKeySection(String pemEncodedFileData) throws ImportExportException {
        Matcher matcher = Pattern.compile(PRIVATE_KEY_PATTERN, 32).matcher(pemEncodedFileData);
        String privateKeySection = "";
        if (matcher.find()) {
            privateKeySection = matcher.group();
        }
        return privateKeySection;
    }

    protected static PrivateKey readEncryptedKey(char[] password, String pemEncodedFileData) throws IOException, PKCSException, NullPointerException, DecoderException {
        PEMParser parser = new PEMParser((Reader)new StringReader(pemEncodedFileData));
        PKCS8EncryptedPrivateKeyInfo encPrivKeyInfo = (PKCS8EncryptedPrivateKeyInfo)parser.readObject();
        InputDecryptorProvider pkcs8Prov = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider(bouncyCastleFipsProvider).build(password);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(bouncyCastleFipsProvider);
        return converter.getPrivateKey(encPrivKeyInfo.decryptPrivateKeyInfo(pkcs8Prov));
    }

    protected static List<X509Certificate> getCerts(InputStream fileDataStream) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance(X509_TYPE);
        Collection<? extends Certificate> certificates = certFactory.generateCertificates(fileDataStream);
        LinkedList<? extends Certificate> certList = new LinkedList<Certificate>(certificates);
        return certList;
    }

    public static boolean isPemFileType(byte[] fileData) throws ImportExportException {
        String pemString = new String(fileData, StandardCharsets.UTF_8);
        String searchString = "----BEGIN";
        return pemString.indexOf(searchString) >= 0;
    }
}

