/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import com.pingidentity.pingcommons.security.PKCS10Proxy;
import com.pingidentity.pingcommons.security.X509CertInfo;
import com.pingidentity.pingcommons.util.DNUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class CertificateUtil {
    private static final String X509_TYPE = "X.509";

    public static X509Certificate createSelfSignedCert(String cn, String ou, String o, String l, String st, String c, int validDays, KeyPair keyPair, String sigAlgorithm, Date validFrom) throws GeneralSecurityException, IOException {
        return CertificateUtil.createSelfSignedCert(cn, ou, o, l, st, c, validDays, keyPair, sigAlgorithm, validFrom, null);
    }

    public static X509Certificate createSelfSignedCert(String cn, String ou, String o, String l, String st, String c, int validDays, KeyPair keyPair, String sigAlgorithm, Date validFrom, String provider) throws GeneralSecurityException, IOException {
        X500Name name = CertificateUtil.buildX500Name(cn, ou, o, l, st, c);
        if (validFrom == null) {
            validFrom = new Date();
        }
        Calendar to = Calendar.getInstance();
        to.setTime(new Date());
        to.add(5, validDays);
        return CertificateUtil.buildSelfSignedCert(name, validFrom, to.getTime(), keyPair, sigAlgorithm, null, provider);
    }

    public static X509Certificate createSelfSignedCert(X500Name name, Date from, Date to, KeyPair keyPair, String sigAlgorithm) throws GeneralSecurityException, IOException {
        return CertificateUtil.buildSelfSignedCert(name, from, to, keyPair, sigAlgorithm, null, null);
    }

    public static X509Certificate createSelfSignedCert(X500Name name, Date from, Date to, KeyPair keyPair, String sigAlgorithm, CertificateExtensions extensions) throws GeneralSecurityException, IOException {
        return CertificateUtil.buildSelfSignedCert(name, from, to, keyPair, sigAlgorithm, extensions, null);
    }

    public static X509Certificate createSelfSignedCert(X500Name name, Date from, Date to, KeyPair keyPair, String sigAlgorithm, CertificateExtensions extensions, String provider) throws GeneralSecurityException, IOException {
        return CertificateUtil.buildSelfSignedCert(name, from, to, keyPair, sigAlgorithm, extensions, provider);
    }

    public static X500Name buildX500Name(String cn, String ou, String o, String l, String st, String c) throws IOException {
        return new X500Name(CertificateUtil.buildSubject(cn, ou, o, l, st, c));
    }

    public static String buildSubject(String cn, String ou, String o, String l, String st, String c) {
        StringBuilder dn = new StringBuilder();
        dn.append("CN=");
        String escapedCn = null;
        if (cn != null) {
            escapedCn = DNUtil.escapeDN(cn);
        }
        dn.append(escapedCn);
        if (ou != null && !ou.isEmpty()) {
            dn.append(",");
            dn.append("OU=");
            dn.append(DNUtil.escapeDN(ou));
        }
        if (o != null && !o.isEmpty()) {
            dn.append(",");
            dn.append("O=");
            dn.append(DNUtil.escapeDN(o));
        }
        if (l != null && !l.isEmpty()) {
            dn.append(",");
            dn.append("L=");
            dn.append(DNUtil.escapeDN(l));
        }
        if (st != null && !st.isEmpty()) {
            dn.append(",");
            dn.append("ST=");
            dn.append(DNUtil.escapeDN(st));
        }
        if (c != null && !c.isEmpty()) {
            dn.append(",");
            dn.append("C=");
            dn.append(DNUtil.escapeDN(c));
        }
        return dn.toString();
    }

    public static String encodeCSR(PrivateKey key, X509Certificate cert) throws GeneralSecurityException, IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)buff, false, StandardCharsets.UTF_8.name());
        X500Name name = new X500Name(cert.getSubjectDN().getName());
        Signature sig = Signature.getInstance(cert.getSigAlgName());
        sig.initSign(key);
        try {
            PKCS10Proxy pkcs10 = new PKCS10Proxy(cert.getPublicKey());
            pkcs10.encodeAndSign(name, sig);
            pkcs10.print(out);
        }
        catch (Exception encodeAndSignException) {
            throw new GeneralSecurityException(encodeAndSignException);
        }
        return buff.toString(StandardCharsets.UTF_8.name());
    }

    public static X509Certificate[] decodeCSRReply(InputStream replyInputStream, Collection<X509Certificate> trustedCerts) throws GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance(X509_TYPE);
        Collection<? extends Certificate> collection = cf.generateCertificates(replyInputStream);
        if (collection.isEmpty()) {
            throw new GeneralSecurityException("CSR reply invalid and/or contained no certificate.");
        }
        int nCerts = collection.size();
        X509Certificate[] certsFromInput = new X509Certificate[nCerts];
        int i = 0;
        for (Certificate certificate : collection) {
            certsFromInput[i++] = (X509Certificate)certificate;
        }
        X509Certificate[] orderedCerts = CertificateUtil.orderCertChain(certsFromInput);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        Collections.addAll(arrayList, orderedCerts);
        CertificateUtil.validateCertPath(arrayList, trustedCerts);
        return arrayList.toArray(new X509Certificate[arrayList.size()]);
    }

    public static void validateCertPath(List<X509Certificate> chain, Collection<X509Certificate> trustedCerts) throws CertPathValidatorException {
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate cert : trustedCerts) {
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        ArrayList<X509Certificate> prunedChain = new ArrayList<X509Certificate>();
        Iterator<X509Certificate> iterator = chain.iterator();
        if (iterator.hasNext()) {
            X509Certificate x509;
            prunedChain.add(iterator.next());
            while (iterator.hasNext() && !trustedCerts.contains(x509 = iterator.next())) {
                prunedChain.add(x509);
            }
        }
        CertificateUtil.validateCertPathAgainstTrustAnchors(prunedChain, trustAnchors);
    }

    public static void validateCertPathAgainstTrustAnchors(List<X509Certificate> chain, Set<TrustAnchor> trustAnchors) throws CertPathValidatorException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance(X509_TYPE);
            CertPath certPath = cf.generateCertPath(chain);
            PKIXParameters params = new PKIXParameters(trustAnchors);
            params.setRevocationEnabled(false);
            CertPathValidator validator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            validator.validate(certPath, params);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertPathValidatorException("No Trust Anchors specified", e);
        }
    }

    public static X509Certificate[] orderCertChain(X509Certificate[] inCerts) {
        int NOT_BY_OTHER_IN_CHAIN = 9999;
        X509Certificate[] outCerts = inCerts;
        if (inCerts != null && inCerts.length > 1) {
            int i;
            int numCerts = inCerts.length;
            outCerts = new X509Certificate[numCerts];
            int[] signers = new int[numCerts];
            int[] srcIndice = new int[numCerts];
            int topOfTheChain = 0;
            for (i = 0; i < numCerts; ++i) {
                X509Certificate curCert = inCerts[i];
                Principal issuer = curCert.getIssuerDN();
                int SignerIdx = NOT_BY_OTHER_IN_CHAIN;
                for (int j = 0; j < numCerts; ++j) {
                    Principal subject = inCerts[j].getSubjectDN();
                    if (i == j || !subject.equals(issuer)) continue;
                    SignerIdx = j;
                    break;
                }
                signers[i] = SignerIdx;
                if (SignerIdx != NOT_BY_OTHER_IN_CHAIN) continue;
                topOfTheChain = i;
            }
            srcIndice[numCerts - 1] = topOfTheChain;
            block2: for (int k = numCerts - 2; k >= 0; --k) {
                srcIndice[k] = k;
                for (int k1 = 0; k1 < numCerts; ++k1) {
                    if (signers[k1] != srcIndice[k + 1]) continue;
                    srcIndice[k] = k1;
                    continue block2;
                }
            }
            for (i = 0; i < numCerts; ++i) {
                outCerts[i] = inCerts[srcIndice[i]];
            }
        }
        return outCerts;
    }

    private static X509Certificate buildSelfSignedCert(X500Name name, Date from, Date to, KeyPair keyPair, String sigAlgorithm, CertificateExtensions extensions, String provider) throws GeneralSecurityException, IOException {
        X509CertImpl cert;
        Signature sig = Signature.getInstance(sigAlgorithm);
        sig.initSign(keyPair.getPrivate());
        CertificateValidity validity = new CertificateValidity(from, to);
        X509CertInfo certInfo = new X509CertInfo();
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        try {
            Class<X509CertInfo> certInfoClazz = X509CertInfo.class;
            Method setSerialNumber = certInfoClazz.getMethod("setSerialNumber", CertificateSerialNumber.class);
            setSerialNumber.invoke((Object)certInfo, new CertificateSerialNumber(serial));
            Method setVersion = certInfoClazz.getMethod("setVersion", CertificateVersion.class);
            setVersion.invoke((Object)certInfo, new CertificateVersion(2));
            Method setAlgorithmId = certInfoClazz.getMethod("setAlgorithmId", CertificateAlgorithmId.class);
            setAlgorithmId.invoke((Object)certInfo, new CertificateAlgorithmId(AlgorithmId.get(sig.getAlgorithm())));
            Method setSubject = certInfoClazz.getMethod("setSubject", X500Name.class);
            setSubject.invoke((Object)certInfo, name);
            Method setKey = certInfoClazz.getMethod("setKey", CertificateX509Key.class);
            setKey.invoke((Object)certInfo, new CertificateX509Key(keyPair.getPublic()));
            Method setValidity = certInfoClazz.getMethod("setValidity", CertificateValidity.class);
            setValidity.invoke((Object)certInfo, validity);
            Method setIssuer = certInfoClazz.getMethod("setIssuer", X500Name.class);
            setIssuer.invoke((Object)certInfo, name);
            if (extensions != null) {
                Method setExtensions = certInfoClazz.getMethod("setExtensions", CertificateExtensions.class);
                setExtensions.invoke((Object)certInfo, extensions);
            }
            Class<X509CertImpl> certImplClazz = X509CertImpl.class;
            if (provider != null) {
                Method newSignedMethod = certImplClazz.getMethod("newSigned", sun.security.x509.X509CertInfo.class, PrivateKey.class, String.class, String.class);
                cert = (X509CertImpl)newSignedMethod.invoke(null, certInfo, keyPair.getPrivate(), sig.getAlgorithm(), provider);
            } else {
                Method newSignedMethod = certImplClazz.getMethod("newSigned", sun.security.x509.X509CertInfo.class, PrivateKey.class, String.class);
                cert = (X509CertImpl)newSignedMethod.invoke(null, certInfo, keyPair.getPrivate(), sig.getAlgorithm());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            certInfo.set("serialNumber", new CertificateSerialNumber(serial));
            certInfo.set("version", new CertificateVersion(2));
            certInfo.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(sig.getAlgorithm())));
            certInfo.set("subject", name);
            certInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
            certInfo.set("validity", validity);
            certInfo.set("issuer", name);
            if (extensions != null) {
                certInfo.set("extensions", extensions);
            }
            cert = new X509CertImpl((sun.security.x509.X509CertInfo)certInfo);
            if (provider != null) {
                cert.sign(keyPair.getPrivate(), sig.getAlgorithm(), provider);
            }
            cert.sign(keyPair.getPrivate(), sig.getAlgorithm());
        }
        return cert;
    }
}

