/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import com.pingidentity.pingcommons.crypto.B64;
import com.pingidentity.pingcommons.crypto.ObfuscationException;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtil {
    private static final Logger log = LoggerFactory.getLogger(CryptoUtil.class);
    private static final byte[] HARDCODED_KEY = new byte[]{-85, -17, 27, 47, -54, 15, -110, 5, 123, 32, 37, 104, -108, -122, 98, 45};
    public static final String BLOWFISH = "Blowfish";
    public static final String AES = "AES";
    private static final SecretKeySpec AES_KEY_SPEC = new SecretKeySpec(HARDCODED_KEY, "AES");
    private static final SecretKeySpec BLOWFISH_KEY_SPEC = new SecretKeySpec(HARDCODED_KEY, "Blowfish");
    private static final String VERSION = "version";

    private CryptoUtil() {
    }

    public static Cipher getCipher(int mode, String algorithm) {
        try {
            SecretKeySpec secretKeySpec = CryptoUtil.getSecretKeySpec(algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(mode, secretKeySpec);
            return cipher;
        }
        catch (Exception e) {
            throw new ObfuscationException("Unable to initialize cipher", e);
        }
    }

    public static SecretKeySpec getSecretKeySpec(String algorithm) {
        SecretKeySpec secretKeySpec = null;
        switch (algorithm) {
            case "AES": {
                secretKeySpec = AES_KEY_SPEC;
                break;
            }
            case "Blowfish": {
                secretKeySpec = BLOWFISH_KEY_SPEC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported algorithm: " + algorithm);
            }
        }
        return secretKeySpec;
    }

    public static String obfuscate(String clearText, JsonWebKey jwk) throws JoseException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setPlaintext(clearText);
        jwe.setAlgorithmHeaderValue("dir");
        jwe.setEncryptionMethodHeaderParameter("A128CBC-HS256");
        jwe.setKey(jwk.getKey());
        jwe.setKeyIdHeaderValue(jwk.getKeyId());
        jwe.setHeader(VERSION, CryptoUtil.class.getPackage().getImplementationVersion());
        return jwe.getCompactSerialization();
    }

    @Deprecated
    public static String obfuscate(String clearText, String algorithm) {
        try {
            Cipher cipher = CryptoUtil.getCipher(1, algorithm);
            byte[] obfuscatedBytes = cipher.doFinal(clearText.getBytes(StandardCharsets.UTF_8));
            return B64.encode(obfuscatedBytes);
        }
        catch (Exception e) {
            throw new ObfuscationException("Obfuscating error for algorithm: " + algorithm, e);
        }
    }

    public static String deobfuscate(String obfuscatedText, JsonWebKeySet jsonWebKeySet, String algorithm) {
        try {
            String deobfuscated = CryptoUtil.deobfuscate(obfuscatedText, jsonWebKeySet);
            if (deobfuscated != null) {
                return deobfuscated;
            }
        }
        catch (JoseException joseException) {
            // empty catch block
        }
        return CryptoUtil.deobfuscate(obfuscatedText, algorithm);
    }

    public static String deobfuscate(String obfuscatedText, String algorithm) {
        String clearText = CryptoUtil.doDeobfuscate(obfuscatedText, algorithm);
        if (clearText == null) {
            if (BLOWFISH.equals(algorithm)) {
                clearText = CryptoUtil.doDeobfuscate(obfuscatedText, AES);
            } else if (!CryptoUtil.isFipsMode()) {
                clearText = CryptoUtil.doDeobfuscate(obfuscatedText, BLOWFISH);
            }
        }
        if (clearText == null) {
            throw new ObfuscationException("Unable to deobfuscate text");
        }
        return clearText;
    }

    public static String deobfuscate(String obfuscatedText, JsonWebKey jsonWebKey) throws JoseException {
        return CryptoUtil.deobfuscate(obfuscatedText, new JsonWebKeySet(new JsonWebKey[]{jsonWebKey}));
    }

    public static String deobfuscate(String obfuscatedText, JsonWebKeySet jsonWebKeySet) throws JoseException {
        String deobfuscated = null;
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setCompactSerialization(obfuscatedText);
        if (jwe.getKeyIdHeaderValue() != null) {
            JsonWebKey jwk = jsonWebKeySet.findJsonWebKey(jwe.getKeyIdHeaderValue(), "oct", null, null);
            if (jwk != null) {
                jwe.setKey(jwk.getKey());
                deobfuscated = jwe.getPlaintextString();
            } else {
                log.warn("Unable to find key with id: " + jwe.getKeyIdHeaderValue());
            }
        }
        return deobfuscated;
    }

    private static String doDeobfuscate(String obfuscatedText, String algorithm) {
        String clearText = null;
        try {
            Cipher cipher = CryptoUtil.getCipher(2, algorithm);
            byte[] obfuscatedBytes = B64.decodeToBytes(obfuscatedText);
            clearText = new String(cipher.doFinal(obfuscatedBytes), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        return clearText;
    }

    private static boolean isFipsMode() {
        String paFipsMode = System.getProperty("pa.fips.mode", "false");
        String pfFipsMode = System.getProperty("pf.fips.mode", "false");
        return "true".equals(paFipsMode.trim()) || "true".equals(pfFipsMode.trim());
    }
}

