/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class HashUtil {
    public static String hexEncode(byte[] bytes) {
        char[] encodedHex = Hex.encodeHex((byte[])bytes);
        return new String(encodedHex);
    }

    public static byte[] hashToBytes(byte[] bytes, HashAlgorithm algo) {
        MessageDigest digester = HashUtil.getMessageDigester(algo);
        return digester.digest(bytes);
    }

    public static byte[] hashToBytes(String s, HashAlgorithm algo) {
        byte[] bytes = HashUtil.toBytes(s);
        return HashUtil.hashToBytes(bytes, algo);
    }

    public static String hashToHexString(byte[] bytes, HashAlgorithm algo) {
        if (bytes == null) {
            return null;
        }
        byte[] hashedBytes = HashUtil.hashToBytes(bytes, algo);
        char[] encodedHex = Hex.encodeHex((byte[])hashedBytes);
        return new String(encodedHex);
    }

    public static String hashToHexString(String s, HashAlgorithm algo) {
        if (s == null) {
            return null;
        }
        byte[] bytes = HashUtil.toBytes(s);
        return HashUtil.hashToHexString(bytes, algo);
    }

    public static MessageDigest getMessageDigester(HashAlgorithm algo) {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance(algo.getJceName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return digester;
    }

    private static byte[] toBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }
}

