/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IDGenerator {
    private static final char PLUS = '+';
    private static final char SLASH = '/';
    private static final char EQUAL = '=';
    private static final char UNDERSCORE = '_';
    private static final String UTC_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String TZ_UTC = "UTC";
    private static final ThreadLocalRandom threadLocalRandom = new ThreadLocalRandom();
    public static final String LOWER_STR = "abcdefghijklmnopqrstuvwxyz";
    public static final char[] LOWER = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final String UPPER_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final char[] UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final String ALPHAS_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMERICS_STR = "0123456789";
    public static final String ALPHA_NUMERICS_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static char[] ALPHA_NUMERICS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
    private static final Logger log = LoggerFactory.getLogger(IDGenerator.class);

    public static String rndAlpha(int length) {
        return IDGenerator.rndStr(length, ALPHAS_STR.toCharArray());
    }

    public static String rndNumeric(int length) {
        return IDGenerator.rndStr(length, NUMERICS_STR.toCharArray());
    }

    public static String rndAlphaNumeric(int length) {
        return IDGenerator.rndStr(length, ALPHA_NUMERICS);
    }

    public static String rndStr(int length, char[] fromChars) {
        Random random = (Random)threadLocalRandom.get();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int rnd = random.nextInt(fromChars.length);
            chars[i] = fromChars[rnd];
        }
        return new String(chars);
    }

    public static byte[] generateBytes(int length) {
        Random random = (Random)threadLocalRandom.get();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String createIdentifier() {
        byte[] encoded;
        byte[] data = IDGenerator.generateBytes(20);
        StringBuilder result = new StringBuilder(29);
        result.append("i");
        block4: for (byte current : encoded = Base64.encodeBase64((byte[])data)) {
            switch (current) {
                case 43: 
                case 47: {
                    result.append('_');
                    continue block4;
                }
                case 61: {
                    continue block4;
                }
                default: {
                    result.append((char)current);
                }
            }
        }
        return result.toString();
    }

    public static String nowUtc() {
        return IDGenerator.nowUtcPlus(0);
    }

    public static String nowUtcPlus(int offset) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(IDGenerator.getUtcTimeZone());
        ((Calendar)cal).add(12, offset);
        SimpleDateFormat zulu = new SimpleDateFormat(UTC_FORMAT);
        zulu.setTimeZone(TimeZone.getTimeZone(TZ_UTC));
        return zulu.format(cal.getTime());
    }

    public static TimeZone getUtcTimeZone() {
        return TimeZone.getTimeZone(TZ_UTC);
    }

    private static class ThreadLocalRandom
    extends ThreadLocal<Random> {
        private ThreadLocalRandom() {
        }

        @Override
        protected Random initialValue() {
            return new SecureRandom();
        }
    }
}

