/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import java.io.IOException;
import java.util.regex.Pattern;
import sun.security.util.DerValue;
import sun.security.x509.DNSName;

public class LenientDNSName
extends DNSName {
    private static final String DNS_CHAR_SEQ = "([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])";
    private static final String STRICT_DNS_CHAR_SEQ = "([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])";
    private static final String HOSTNAME_REGEX = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])$";
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])$", 2);
    private static final String STRICT_HOSTNAME_REGEX = "^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])\\.)*([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])$";
    private static final Pattern STRICT_HOSTNAME_PATTERN = Pattern.compile("^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])\\.)*([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])$", 2);
    private static final String HOSTNAME_WITH_WILDCARD_REGEX = "^\\*\\.(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)+([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])$";
    private static final Pattern HOSTNAME_WITH_WILDCARD_PATTERN = Pattern.compile("^\\*\\.(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)+([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])$", 2);
    private static final String STRICT_HOSTNAME_WITH_WILDCARD_REGEX = "^\\*\\.(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])\\.)+([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])$";
    private static final Pattern STRICT_HOSTNAME_WITH_WILDCARD_PATTERN = Pattern.compile("^\\*\\.(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])\\.)+([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z])$", 2);

    public LenientDNSName(DerValue derValue) throws IOException {
        super(derValue);
    }

    public LenientDNSName(String name) throws IOException {
        this(name, ValidationMode.BASIC);
    }

    public LenientDNSName(String name, ValidationMode matchingMode) throws IOException {
        super(new DerValue(22, name));
        if (name.length() == 0) {
            throw new IOException("DNS name must not be empty");
        }
        if (name.indexOf(32) != -1) {
            throw new IOException("DNS names or NameConstraints with blank components are not permitted");
        }
        if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            throw new IOException("DNS names or NameConstraints may not begin or end with a .");
        }
        if (!matchingMode.validate(name)) {
            throw new IOException("Invalid DNS name");
        }
    }

    @Override
    public String toString() {
        return String.format("%s: %s", this.getClass().getSimpleName(), this.getName());
    }

    public static enum ValidationMode {
        BASIC{

            @Override
            boolean validate(String dnsName) {
                return HOSTNAME_PATTERN.matcher(dnsName).find() || HOSTNAME_WITH_WILDCARD_PATTERN.matcher(dnsName).find();
            }
        }
        ,
        STRICT{

            @Override
            boolean validate(String dnsName) {
                return STRICT_HOSTNAME_PATTERN.matcher(dnsName).find() || STRICT_HOSTNAME_WITH_WILDCARD_PATTERN.matcher(dnsName).find();
            }
        };


        abstract boolean validate(String var1);
    }
}

