/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import com.pingidentity.pingcommons.crypto.CryptoUtil;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

public class Password {
    public static final String PREFIX_OBF = "OBF";
    public static final String PREFIX_JWE = "JWE";
    public static final String PREFIX_AES = "AES";
    public static final String PREFIX_SHA1 = "SHA1";
    public static final String DELIMITER = ":";
    private String strValue = null;

    public Password(String password, JsonWebKeySet jsonWebKeySet) {
        this(password, jsonWebKeySet, PREFIX_AES);
    }

    public Password(String password, JsonWebKeySet jsonWebKeySet, String defaultAlgorithm) {
        this.strValue = password;
        if (!StringUtils.isEmpty((String)password)) {
            String[] tokens = password.split(DELIMITER);
            block1 : switch (tokens.length) {
                case 3: {
                    if (PREFIX_OBF.equals(tokens[0])) {
                        switch (tokens[1]) {
                            case "JWE": {
                                try {
                                    this.strValue = CryptoUtil.deobfuscate(tokens[2], jsonWebKeySet);
                                    break block1;
                                }
                                catch (JoseException e) {
                                    throw new IllegalArgumentException("Invalid password", e);
                                }
                            }
                        }
                        if (!this.validHash(tokens[0] + DELIMITER + tokens[1], tokens[2])) break;
                        this.strValue = CryptoUtil.deobfuscate(tokens[1], defaultAlgorithm);
                        break;
                    }
                    if (!PREFIX_SHA1.equals(tokens[0])) break;
                    this.strValue = null;
                    break;
                }
                case 4: {
                    if (!this.validHash(tokens[0] + DELIMITER + tokens[1] + DELIMITER + tokens[2], tokens[3]) || !PREFIX_OBF.equals(tokens[0])) break;
                    this.strValue = CryptoUtil.deobfuscate(tokens[2], tokens[1]);
                    break;
                }
            }
        }
    }

    public String getStrValue() {
        return this.strValue;
    }

    private boolean validHash(String value, String hash) {
        return HashUtil.hashToHexString(value, HashAlgorithm.SHA1).equalsIgnoreCase(hash);
    }
}

