/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import com.pingidentity.pingcommons.crypto.CryptoUtil;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

public class PasswordUtil {
    public static final String JWE_PREFIX = "OBF:JWE:";
    public static final String AES_PREFIX = "OBF:AES:";

    private PasswordUtil() {
    }

    public static String obfuscateAndEncode(String password, JsonWebKey jsonWebKey) throws JoseException {
        return JWE_PREFIX + CryptoUtil.obfuscate(password, jsonWebKey);
    }

    @Deprecated
    public static String obfuscateAndEncode(String pwd) {
        String encryptedValue = CryptoUtil.obfuscate(pwd, "AES");
        String verificationCode = HashUtil.hashToHexString(AES_PREFIX + encryptedValue, HashAlgorithm.SHA1);
        return AES_PREFIX + encryptedValue + ":" + verificationCode;
    }

    public static String decodeAndDeobfuscate(String password, JsonWebKeySet jsonWebKeySet) throws JoseException {
        if (password == null || !password.startsWith(JWE_PREFIX)) {
            return null;
        }
        return CryptoUtil.deobfuscate(password.substring(JWE_PREFIX.length()), jsonWebKeySet);
    }

    public static String hashAndEncode(String password) {
        String hashed = HashUtil.hashToHexString(password, HashAlgorithm.SHA1);
        String verificationCode = HashUtil.hashToHexString("SHA1:" + hashed, HashAlgorithm.SHA1);
        return "SHA1:" + hashed + ":" + verificationCode;
    }
}

