/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import java.security.cert.X509Certificate;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class X509CertificateValueHelper {
    private String commonName;
    private String country;
    private String orgUnit;
    private String org;
    private String city;
    private String state;
    private X509Certificate x509Cert;

    public X509CertificateValueHelper(X509Certificate x509Cert) {
        try {
            this.x509Cert = x509Cert;
            this.initialize();
        }
        catch (InvalidNameException e) {
            throw new RuntimeException("Certificate has invalid subject name", e);
        }
    }

    private void initialize() throws InvalidNameException {
        String dn = this.x509Cert.getSubjectX500Principal().getName();
        LdapName ldapDN = new LdapName(dn);
        this.commonName = this.getFirstRdn(ldapDN.getRdns(), "CN");
        this.country = this.getFirstRdn(ldapDN.getRdns(), "C");
        this.orgUnit = this.getFirstRdn(ldapDN.getRdns(), "OU");
        this.org = this.getFirstRdn(ldapDN.getRdns(), "O");
        this.city = this.getFirstRdn(ldapDN.getRdns(), "L");
        this.state = this.getFirstRdn(ldapDN.getRdns(), "ST");
    }

    private String getFirstRdn(List<Rdn> rdns, String type) {
        for (Rdn rdn : rdns) {
            if (!type.equals(rdn.getType()) || !(rdn.getValue() instanceof String)) continue;
            return (String)rdn.getValue();
        }
        return null;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getCountry() {
        return this.country;
    }

    public String getOrgUnit() {
        return this.orgUnit;
    }

    public String getOrg() {
        return this.org;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public Long getValidDays() {
        Long validityDays = null;
        Long notBeforeTime = this.x509Cert.getNotBefore().getTime();
        Long notAfterTime = this.x509Cert.getNotAfter().getTime();
        Long validityTime = notAfterTime - notBeforeTime;
        validityDays = validityTime / 86400000L;
        return validityDays;
    }
}

