/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.http.uri;

import com.pingidentity.pingcommons.http.uri.HttpUri;

public abstract class BaseHttpUri
implements HttpUri {
    private String getUri(boolean includeQuery) {
        String fragment;
        String query;
        String path;
        StringBuilder uri = new StringBuilder();
        String scheme = this.getScheme();
        String host = this.getHost();
        if (scheme != null && host != null) {
            boolean includePort;
            uri.append(scheme).append("://").append(this.getHost());
            int port = this.getPort();
            switch (port) {
                case 80: {
                    includePort = !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("ws");
                    break;
                }
                case 443: {
                    includePort = !scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("wss");
                    break;
                }
                default: {
                    includePort = true;
                }
            }
            if (includePort) {
                uri.append(":").append(port);
            }
        }
        if ((path = this.getPath()) != null) {
            uri.append(path);
        }
        if ((query = this.getQuery()) != null && includeQuery) {
            uri.append("?").append(query);
        }
        if ((fragment = this.getFragment()) != null && includeQuery) {
            uri.append("#").append(fragment);
        }
        return uri.toString();
    }

    @Override
    public String getUri() {
        return this.getUri(true);
    }

    @Override
    public String getResourceUri() {
        return this.getUri(false);
    }

    @Override
    public String getRelativeUri() {
        String fragment;
        StringBuilder uri = new StringBuilder();
        String path = this.getPath();
        if (path != null) {
            uri.append(path);
        } else {
            uri.append("/");
        }
        String query = this.getQuery();
        if (query != null) {
            uri.append("?").append(query);
        }
        if ((fragment = this.getFragment()) != null) {
            uri.append("#").append(fragment);
        }
        return uri.toString();
    }

    @Override
    public String getAuthority() {
        StringBuilder authority = new StringBuilder();
        String host = this.getHost();
        if (host != null) {
            authority.append(host);
            int port = this.getPort();
            if (port != -1) {
                authority.append(":").append(port);
            }
            return authority.toString();
        }
        return null;
    }

    public String toString() {
        return this.getUri();
    }
}

