/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.http.uri;

import com.pingidentity.pingcommons.http.uri.BaseHttpUri;
import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import com.pingidentity.pingcommons.http.uri.QueryFragmentParser;
import com.pingidentity.pingcommons.lang.EOLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUriReference
extends BaseHttpUri {
    private static final Logger logger = LoggerFactory.getLogger(BaseUriReference.class);
    protected final URI prefix;
    protected final String host;
    protected final int port;
    protected final String query;
    protected final String fragment;

    protected BaseUriReference(String inputUri, boolean requireAbsolute, boolean ignoreFragment, boolean allowWs, boolean strict) throws InvalidHttpUriException {
        if (StringUtils.isBlank((String)inputUri)) {
            throw new InvalidHttpUriException(inputUri, "URI cannot be empty");
        }
        if (EOLUtil.hasEOLs(inputUri)) {
            throw new InvalidHttpUriException(inputUri, "URI cannot contain EOL characters");
        }
        if (strict) {
            try {
                this.prefix = new URI(inputUri);
            }
            catch (URISyntaxException e) {
                throw new InvalidHttpUriException(inputUri, "URI is invalid", e);
            }
            this.query = this.prefix.getRawQuery();
            if (ignoreFragment) {
                this.fragment = null;
                if (this.prefix.getRawFragment() != null) {
                    logger.debug("Fragment silently removed from URI '{}'", (Object)inputUri);
                }
            } else {
                this.fragment = this.prefix.getRawFragment();
            }
        } else {
            QueryFragmentParser queryFragmentParser = new QueryFragmentParser(inputUri);
            this.query = queryFragmentParser.getQuery();
            if (ignoreFragment) {
                this.fragment = null;
                if (queryFragmentParser.getFragment() != null) {
                    logger.debug("Fragment silently removed from URI '{}'", (Object)inputUri);
                }
            } else {
                this.fragment = queryFragmentParser.getFragment();
            }
            try {
                this.prefix = new URI(queryFragmentParser.getPrefix());
            }
            catch (URISyntaxException e) {
                throw new InvalidHttpUriException(inputUri, "URI prefix is invalid", e);
            }
        }
        if (!this.prefix.isAbsolute() && requireAbsolute) {
            throw new InvalidHttpUriException(inputUri, "URI must be absolute");
        }
        if (this.prefix.getScheme() == null && requireAbsolute) {
            throw new InvalidHttpUriException(inputUri, "URI must have a scheme");
        }
        if (this.prefix.getHost() == null && requireAbsolute) {
            throw new InvalidHttpUriException(inputUri, "URI must have a host");
        }
        if (!StringUtils.isBlank((String)this.prefix.getRawPath()) && !this.prefix.getPath().startsWith("/")) {
            throw new InvalidHttpUriException(inputUri, "URI path must be empty or start with /");
        }
        String uriHost = this.prefix.getHost();
        if (uriHost != null) {
            uriHost = uriHost.toLowerCase(Locale.ENGLISH);
        }
        this.host = uriHost;
        if (this.prefix.getScheme() != null) {
            int defaultPort;
            switch (this.prefix.getScheme().toLowerCase(Locale.ENGLISH)) {
                case "http": {
                    defaultPort = 80;
                    break;
                }
                case "ws": {
                    if (allowWs) {
                        defaultPort = 80;
                        break;
                    }
                    throw new InvalidHttpUriException(inputUri, "URI cannot use WS scheme");
                }
                case "https": {
                    defaultPort = 443;
                    break;
                }
                case "wss": {
                    if (allowWs) {
                        defaultPort = 443;
                        break;
                    }
                    throw new InvalidHttpUriException(inputUri, "URI cannot use WSS scheme");
                }
                default: {
                    throw new InvalidHttpUriException(inputUri, "URI must use HTTP/HTTPS scheme");
                }
            }
            this.port = this.prefix.getPort() == -1 ? defaultPort : this.prefix.getPort();
        } else {
            this.port = this.prefix.getPort();
        }
    }

    @Override
    public String getScheme() {
        String scheme = this.prefix.getScheme();
        if (scheme != null) {
            return scheme.toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getPath() {
        if (StringUtils.isBlank((String)this.prefix.getRawPath())) {
            return null;
        }
        return this.prefix.getRawPath();
    }

    @Override
    public String getDecodedPath() {
        String decodedPath = this.prefix.getPath();
        if (StringUtils.isBlank((String)decodedPath)) {
            return null;
        }
        return decodedPath;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getFragment() {
        return this.fragment;
    }
}

