/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.http.uri;

import com.pingidentity.pingcommons.http.uri.BaseHttpUri;
import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import com.pingidentity.pingcommons.http.uri.OriginFormRequestTargetUtil;
import java.net.URI;
import java.net.URISyntaxException;

public class NormalizeStrictOriginFormUri
extends BaseHttpUri {
    private final URI uri;
    private final String query;

    NormalizeStrictOriginFormUri(String rawRequestTarget, boolean canonicalize) throws InvalidHttpUriException {
        OriginFormRequestTargetUtil.validateRawRequestTarget(rawRequestTarget);
        try {
            URI firstPassUri = OriginFormRequestTargetUtil.createUri(rawRequestTarget).normalize();
            this.query = firstPassUri.getRawQuery();
            if (canonicalize) {
                String finalPath = OriginFormRequestTargetUtil.canonicalizeUri(firstPassUri.getRawPath());
                this.uri = OriginFormRequestTargetUtil.createUri(finalPath).normalize();
            } else {
                this.uri = firstPassUri;
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidHttpUriException(rawRequestTarget, "request-target path is invalid", e);
        }
    }

    @Override
    public String getScheme() {
        return null;
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public String getPath() {
        return this.uri.getRawPath();
    }

    @Override
    public String getDecodedPath() {
        return this.uri.getPath();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getFragment() {
        return null;
    }
}

