/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.http.uri;

import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import com.pingidentity.pingcommons.lang.EOLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class OriginFormRequestTargetUtil {
    public static final String EMPTY_PATH_REGEX = "(?:/|%2f)(?:/|%2f)+";
    public static final Pattern EMPTY_PATH_PATTERN = Pattern.compile("(?:/|%2f)(?:/|%2f)+", 2);
    public static final String DOT_PATH_REGEX = "(?:/|%2f)(?:\\.|%2e)(?:/|%2f)";
    public static final Pattern DOT_PATH_PATTERN = Pattern.compile("(?:/|%2f)(?:\\.|%2e)(?:/|%2f)", 2);
    public static final String ENCODED_DOT_PATH_REGEX = "/%2e(?:/|%2f)";
    public static final Pattern ENCODED_DOT_PATH_PATTERN = Pattern.compile("/%2e(?:/|%2f)", 2);
    public static final String ENCODED_FINAL_SLASH_PATH_REGEX = "/\\.%2f";
    public static final Pattern ENCODED_FINAL_SLASH_PATH_PATTERN = Pattern.compile("/\\.%2f", 2);
    public static final String TRAILING_DOT_PATH_SEGMENT_REGEX = "(?:/|%2f)(?:\\.|%2e)$";
    public static final Pattern TRAILING_DOT_PATH_SEGMENT_PATTERN = Pattern.compile("(?:/|%2f)(?:\\.|%2e)$", 2);

    private OriginFormRequestTargetUtil() {
    }

    static void validateRawRequestTarget(String rawRequestTarget) throws InvalidHttpUriException {
        if (StringUtils.isBlank((String)rawRequestTarget)) {
            throw new InvalidHttpUriException(rawRequestTarget, "request-target cannot be empty");
        }
        if (EOLUtil.hasEOLs(rawRequestTarget)) {
            throw new InvalidHttpUriException(rawRequestTarget, "request-target cannot contain eol characters");
        }
        if (rawRequestTarget.charAt(0) != '/') {
            throw new InvalidHttpUriException(rawRequestTarget, "request-target must start with a /");
        }
    }

    static URI createUri(String requestPath) throws URISyntaxException {
        return new URI("https://dummyHost" + requestPath);
    }

    static String canonicalizeUri(String requestPath) {
        if (!StringUtils.containsIgnoreCase((String)requestPath, (String)"%2f") && !StringUtils.containsIgnoreCase((String)requestPath, (String)"%2e")) {
            return requestPath;
        }
        String path = DOT_PATH_PATTERN.matcher(requestPath).replaceAll("/./");
        path = ENCODED_DOT_PATH_PATTERN.matcher(path).replaceAll("/./");
        path = ENCODED_FINAL_SLASH_PATH_PATTERN.matcher(path).replaceAll("/./");
        path = EMPTY_PATH_PATTERN.matcher(path).replaceAll("//");
        path = TRAILING_DOT_PATH_SEGMENT_PATTERN.matcher(path).replaceAll("/.");
        return path;
    }
}

