/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.lang;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class LocalizationUtil {
    public static final String RTL = "rtl";
    public static final String LTR = "ltr";
    private static final Set<String> RTL_LANGS;
    private static final Set<String> RTL_SCRIPTS;
    private static final Set<String> ALWAYS_LTR_SCRIPTS;

    private LocalizationUtil() {
    }

    public static String getOrientation(Locale locale) {
        String orientation = LTR;
        if (locale != null) {
            String lang = null;
            String script = null;
            if (locale.getLanguage() != null) {
                lang = locale.getLanguage().toLowerCase();
            }
            if (locale.getScript() != null) {
                script = locale.getScript().toLowerCase();
            }
            if ((RTL_LANGS.contains(lang) || RTL_SCRIPTS.contains(script)) && !ALWAYS_LTR_SCRIPTS.contains(script)) {
                orientation = RTL;
            }
        }
        return orientation;
    }

    static {
        HashSet<String> rtl_langs = new HashSet<String>();
        rtl_langs.add("ar");
        rtl_langs.add("dv");
        rtl_langs.add("iw");
        rtl_langs.add("fa");
        rtl_langs.add("nqo");
        rtl_langs.add("ps");
        rtl_langs.add("sd");
        rtl_langs.add("ug");
        rtl_langs.add("ur");
        rtl_langs.add("ji");
        RTL_LANGS = Collections.unmodifiableSet(rtl_langs);
        HashSet<String> rtl_scripts = new HashSet<String>();
        rtl_scripts.add("arab");
        rtl_scripts.add("hebr");
        rtl_scripts.add("thaa");
        rtl_scripts.add("nkoo");
        rtl_scripts.add("tfng");
        RTL_SCRIPTS = Collections.unmodifiableSet(rtl_scripts);
        HashSet<String> ltr_scripts = new HashSet<String>();
        ltr_scripts.add("latn");
        ltr_scripts.add("cyrl");
        ALWAYS_LTR_SCRIPTS = Collections.unmodifiableSet(ltr_scripts);
    }
}

