/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.log;

import com.google.common.base.CharMatcher;
import com.pingidentity.pingcommons.crypto.B64;
import com.pingidentity.pingcommons.lang.EOLUtil;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class LogGuard {
    private static final int MAX_LENGTH = 200;
    private static final int MAX_STRING_LENGTH = 100;
    private static final String LF_REPLACEMENT = "<LF>";
    private static final String CR_REPLACEMENT = "<CR>";
    private static final String SANITIZED_SUFFIX = "(ENCODED)";
    private static final Pattern LF_PATTERN = Pattern.compile("\n", 16);
    private static final Pattern CR_PATTERN = Pattern.compile("\r", 16);

    private LogGuard() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated");
    }

    public static String b64Encode(String unclean) {
        if (unclean == null) {
            return unclean;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(Unsanitized data");
        if (unclean.length() > 200) {
            unclean = StringUtils.substring((String)unclean, (int)0, (int)200);
            sb.append(" truncated and");
        }
        String str = B64.encode(unclean);
        sb.append(" Base64 encoded: ").append(str).append(")");
        return sb.toString();
    }

    public static String encode(String unclean) {
        if (StringUtils.isEmpty((String)unclean)) {
            return unclean;
        }
        if (!EOLUtil.hasEOLs(unclean) && !LogGuard.containsANSIControlSequences(unclean)) {
            return unclean;
        }
        String cleaned = unclean;
        cleaned = LF_PATTERN.matcher(cleaned).replaceAll(LF_REPLACEMENT);
        cleaned = CR_PATTERN.matcher(cleaned).replaceAll(CR_REPLACEMENT);
        cleaned = LogGuard.removeANSIControlSequences(cleaned);
        cleaned = cleaned + SANITIZED_SUFFIX;
        return cleaned;
    }

    public static String[] encode(String[] unclean) {
        if (unclean == null || unclean.length == 0) {
            return unclean;
        }
        return (String[])Arrays.stream(unclean).map(LogGuard::encode).toArray(String[]::new);
    }

    public static String encode(StringBuffer unclean) {
        if (unclean == null) {
            return null;
        }
        return LogGuard.encode(unclean.toString());
    }

    public static String encode(StringBuilder unclean) {
        if (unclean == null) {
            return null;
        }
        return LogGuard.encode(unclean.toString());
    }

    public static String truncateAndEncode(String unclean) {
        if (unclean != null && unclean.length() > 100) {
            return LogGuard.encode(StringUtils.substring((String)unclean, (int)0, (int)100) + "(TRUNCATED)");
        }
        return LogGuard.encode(unclean);
    }

    private static boolean containsANSIControlSequences(String s) {
        return CharMatcher.javaIsoControl().matchesAnyOf((CharSequence)s);
    }

    private static String removeANSIControlSequences(String unclean) {
        return CharMatcher.javaIsoControl().removeFrom((CharSequence)unclean);
    }
}

