/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.Formatter;
import java.util.Locale;
import org.slf4j.Logger;

public class LoggerPrintStream
extends PrintStream {
    private final boolean autoFlush;
    private boolean trouble = false;
    private Formatter formatter;
    private String lineSeparator = System.lineSeparator();
    private boolean closing = false;

    protected LoggerPrintStream(LoggerOutputStream los) {
        super(los);
        this.autoFlush = true;
    }

    public static void setSystemOutToLogger(Logger logger) {
        LoggerOutputStream los = new LoggerOutputStream(logger);
        LoggerPrintStream lps = new LoggerPrintStream(los);
        try {
            System.setOut(lps);
        }
        catch (SecurityException e) {
            logger.warn("Unable to overwrite System out stream: " + e.getMessage());
        }
    }

    public static void setSystemErrToLogger(Logger logger) {
        LoggerOutputStream los = new LoggerOutputStream(logger, true);
        LoggerPrintStream lps = new LoggerPrintStream(los);
        try {
            System.setErr(lps);
        }
        catch (SecurityException e) {
            logger.warn("Unable to overwrite System err stream: " + e.getMessage());
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void flush() {
        try {
            this.ensureOpen();
            this.out.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void close() {
        if (!this.closing) {
            this.closing = true;
            try {
                this.out.close();
            }
            catch (IOException x) {
                this.trouble = true;
            }
            this.out = null;
        }
    }

    @Override
    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        if (this.out instanceof PrintStream) {
            PrintStream ps = (PrintStream)this.out;
            return ps.checkError();
        }
        return this.trouble;
    }

    @Override
    protected void setError() {
        this.trouble = true;
    }

    @Override
    protected void clearError() {
        this.trouble = false;
    }

    @Override
    public void write(int b) {
        try {
            this.ensureOpen();
            this.out.write(b);
            if (b == 10 && this.autoFlush) {
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            this.ensureOpen();
            this.out.write(buf, off, len);
            if (this.autoFlush) {
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    private void write(String s) {
        try {
            this.ensureOpen();
            byte[] byteBuf = s.getBytes();
            this.out.write(byteBuf, 0, byteBuf.length);
            if (this.autoFlush && s.indexOf(10) >= 0) {
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    private void newLine() {
        try {
            this.ensureOpen();
            this.write(this.lineSeparator);
            if (this.autoFlush) {
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void println() {
        this.newLine();
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(Object x) {
        String s = String.valueOf(x);
        this.print(s);
        this.newLine();
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        try {
            this.ensureOpen();
            if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
                this.formatter = new Formatter((Appendable)this);
            }
            this.formatter.format(Locale.getDefault(), format, args);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
        return this;
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        try {
            this.ensureOpen();
            if (this.formatter == null || this.formatter.locale() != l) {
                this.formatter = new Formatter(this, l);
            }
            this.formatter.format(l, format, args);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
        return this;
    }

    private static class LoggerOutputStream
    extends ByteArrayOutputStream {
        private static final int INIT_BUF_SIZE = 256;
        private final Logger log;
        private final boolean logToErrorLevel;

        public LoggerOutputStream(Logger log) {
            super(256);
            this.log = log;
            this.logToErrorLevel = false;
        }

        public LoggerOutputStream(Logger log, boolean logToError) {
            super(256);
            this.log = log;
            this.logToErrorLevel = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            String str = "";
            LoggerOutputStream loggerOutputStream = this;
            synchronized (loggerOutputStream) {
                if (this.count == 0) {
                    return;
                }
                str = new String(this.buf, 0, this.count);
                this.buf = new byte[256];
                this.count = 0;
            }
            if (str.length() != 1 || str.charAt(0) != '\n') {
                if (str.charAt(str.length() - 1) == '\n') {
                    this.log(str.substring(0, str.length() - 1));
                } else {
                    this.log(str);
                }
            }
        }

        private void log(String str) {
            if (this.logToErrorLevel) {
                this.log.error(str);
            } else {
                this.log.info(str);
            }
        }
    }
}

