/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.mask;

import java.util.List;
import java.util.Set;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.CompactSerializer;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.InvalidKeyException;

public class JwtMasker {
    private final AlgorithmConstraints jweAlgorithmConstraints;

    public JwtMasker() {
        this.jweAlgorithmConstraints = null;
    }

    public JwtMasker(AlgorithmConstraints jweAlgorithmConstraints) {
        this.jweAlgorithmConstraints = jweAlgorithmConstraints;
    }

    public String mask(String jwt, Set<String> maskedAttributeNames) throws InvalidJwtException {
        JwtContext jwtCtx;
        if (maskedAttributeNames.isEmpty()) {
            return jwt;
        }
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder();
        jwtConsumerBuilder.setSkipSignatureVerification();
        jwtConsumerBuilder.setDisableRequireSignature();
        jwtConsumerBuilder.setSkipAllValidators();
        if (this.jweAlgorithmConstraints != null) {
            jwtConsumerBuilder.setJweAlgorithmConstraints(this.jweAlgorithmConstraints);
        }
        JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
        try {
            jwtCtx = jwtConsumer.process(jwt);
        }
        catch (InvalidJwtException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidKeyException) {
                return jwt;
            }
            throw e;
        }
        JwtClaims claims = jwtCtx.getJwtClaims();
        String mask = "*****";
        for (String maskedAttribute : maskedAttributeNames) {
            if (!claims.hasClaim(maskedAttribute)) continue;
            claims.setClaim(maskedAttribute, (Object)"*****");
        }
        String payload = CompactSerializer.serialize((String[])new String[]{claims.toJson()});
        String maskedJwt = "*****";
        Base64Url base64Url = new Base64Url();
        List joseObjects = jwtCtx.getJoseObjects();
        for (JsonWebStructure joseObject : joseObjects) {
            JsonWebSignature jws = (JsonWebSignature)joseObject;
            payload = maskedJwt = CompactSerializer.serialize((String[])new String[]{jws.getHeaders().getEncodedHeader(), base64Url.base64UrlEncodeUtf8ByteRepresentation(payload), jws.getEncodedSignature()});
        }
        return maskedJwt;
    }
}

