/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.security;

import com.pingidentity.pingcommons.security.AccountLockingService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountLockingServiceBase
implements AccountLockingService {
    protected static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(null, r, "AccountLockingService Cleanup Thread");
            t.setDaemon(true);
            return t;
        }
    });

    protected abstract Logger getLogger();

    @Override
    public synchronized boolean isLocked(String key) {
        return this.isLocked(key, this.getMaxConsecutiveFailures(), this.getLockoutPeriod());
    }

    @Override
    public synchronized boolean isLocked(String key, int maxFailedLogins, int lockoutPeriod) {
        return this.isLocked(key, maxFailedLogins, this.getMaxMaliciousActions(), lockoutPeriod);
    }

    @Override
    public boolean isLocked(String key, int maxFailedLogins, int maxMaliciousActions, int lockoutPeriod) {
        boolean isLocked = false;
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (this.getFailureMap().containsKey(key)) {
            AccountLockingService.AccountLockingState failureState = this.getFailureMap().get(key);
            isLocked = this.checkLockingState(failureState, lockoutPeriod, maxFailedLogins);
        } else if (this.getMaliciousActionsMap().containsKey(key)) {
            AccountLockingService.AccountLockingState failureState = this.getMaliciousActionsMap().get(key);
            isLocked = this.checkLockingState(failureState, lockoutPeriod, maxMaliciousActions);
        }
        return isLocked;
    }

    private boolean checkLockingState(AccountLockingService.AccountLockingState failureState, int lockoutPeriod, int maxConsecutiveFailures) {
        boolean isLocked = false;
        long currentTimeMillis = this.getCurrentTimeMillis();
        long lockoutPeriodMillis = (long)lockoutPeriod * 60L * 1000L;
        failureState.setLockoutPeriod(lockoutPeriod);
        failureState.deleteFailuresOlderThan(currentTimeMillis - lockoutPeriodMillis);
        if (failureState.getLockExpiry() > currentTimeMillis) {
            isLocked = true;
        } else if (failureState.getFailureCount() >= maxConsecutiveFailures) {
            failureState.setLockExpiry(currentTimeMillis + lockoutPeriodMillis);
            isLocked = true;
        }
        return isLocked;
    }

    @Override
    public synchronized void logFailedLogin(String key) {
        this.logFailure(this.getFailureMap(), key);
    }

    @Override
    public synchronized void logMaliciousAction(String key) {
        this.logFailure(this.getMaliciousActionsMap(), key);
    }

    private synchronized void logFailure(Map<String, AccountLockingService.AccountLockingState> map, String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        long currentTimeMillis = this.getCurrentTimeMillis();
        if (map.containsKey(key)) {
            AccountLockingService.AccountLockingState failureState = map.get(key);
            failureState.addFailure(currentTimeMillis);
        } else {
            AccountLockingService.AccountLockingState failureState = new AccountLockingService.AccountLockingState();
            failureState.addFailure(currentTimeMillis);
            map.put(key, failureState);
        }
    }

    @Override
    public synchronized void clearFailedLogins(String key) {
        if (this.clearFailure(this.getFailureMap(), key) && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("cleared failed logins for " + key);
        }
    }

    @Override
    public synchronized void clearMaliciousActions(String key) {
        if (this.clearFailure(this.getMaliciousActionsMap(), key) && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("cleared malicious actions for " + key);
        }
    }

    private synchronized boolean clearFailure(Map<String, AccountLockingService.AccountLockingState> map, String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return map.remove(key) != null;
    }

    public static class AccountLockingCleanupTask
    implements Runnable {
        private static final short CLEANUP_CHUNK_SIZE = 500;
        private final Map<String, AccountLockingService> instances;
        private static Logger logger = LoggerFactory.getLogger(AccountLockingCleanupTask.class);

        public AccountLockingCleanupTask(Map<String, AccountLockingService> instances) {
            this.instances = instances;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashSet<String> alsInstanceNames = new HashSet<String>();
                long currentTime = this.getCurrentTimeMillis();
                Map<String, AccountLockingService> map = this.instances;
                synchronized (map) {
                    alsInstanceNames.addAll(this.instances.keySet());
                }
                for (String alsInstanceName : alsInstanceNames) {
                    AccountLockingService alsInstance = this.instances.get(alsInstanceName);
                    boolean failureMapClean = false;
                    if (alsInstance.getFailureMap().size() == 0 && alsInstance.getMaliciousActionsMap().size() == 0) continue;
                    MutableInt index = new MutableInt();
                    while (true) {
                        AccountLockingService accountLockingService = alsInstance;
                        synchronized (accountLockingService) {
                            if (!failureMapClean) {
                                if (!this.cleanupChunk(alsInstance.getFailureMap(), currentTime, index)) {
                                    failureMapClean = true;
                                    index.setValue(0);
                                }
                            } else if (!this.cleanupChunk(alsInstance.getMaliciousActionsMap(), currentTime, index)) {
                                break;
                            }
                        }
                    }
                    logger.debug("Cleaned instances for " + alsInstanceName + ". Failed logins - " + alsInstance.getFailureMap().size() + ", Malicious actions - " + alsInstance.getMaliciousActionsMap().size());
                }
            }
            catch (Exception e) {
                logger.error("Error occurred while cleaning Account Locking Service", (Throwable)e);
                throw e;
            }
        }

        private boolean cleanupChunk(Map<String, AccountLockingService.AccountLockingState> map, long currentTime, MutableInt currentIndex) {
            int skipIndex = 0;
            int chunkCounter = 0;
            Iterator<AccountLockingService.AccountLockingState> alsIt = map.values().iterator();
            while (alsIt.hasNext()) {
                AccountLockingService.AccountLockingState lockingState = alsIt.next();
                if (skipIndex < currentIndex.intValue()) {
                    ++skipIndex;
                    continue;
                }
                long lockoutPeriodMillis = (long)lockingState.getLockoutPeriod() * 60L * 1000L;
                lockingState.deleteFailuresOlderThan(currentTime - lockoutPeriodMillis);
                chunkCounter = (short)(chunkCounter + 1);
                if (lockingState.getFailureCount() == 0) {
                    alsIt.remove();
                } else {
                    currentIndex.increment();
                }
                if (chunkCounter != 500) continue;
                break;
            }
            return alsIt.hasNext();
        }

        long getCurrentTimeMillis() {
            return System.currentTimeMillis();
        }
    }
}

