/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.storage.fs;

import com.pingidentity.pingcommons.storage.TextStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class FsTextStore
implements TextStore {
    private String filePath;

    public FsTextStore(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public String load() throws IOException {
        if (new File(this.filePath).exists()) {
            byte[] encoded = Files.readAllBytes(Paths.get(this.filePath, new String[0]));
            return new String(encoded, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public void save(String text) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filePath), StandardCharsets.UTF_8);){
            writer.write(text);
        }
    }
}

