/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.upgrade.file;

import com.pingidentity.pingcommons.upgrade.file.MavenCoordinates;
import com.pingidentity.pingcommons.upgrade.file.MavenJarUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactInventory
implements Iterable<MavenCoordinates> {
    private static final Logger logger = LoggerFactory.getLogger(ArtifactInventory.class);
    private final SortedSet<MavenCoordinates> coordinates;

    private ArtifactInventory(Set<MavenCoordinates> coordinates) {
        this.coordinates = Collections.unmodifiableSortedSet(new TreeSet<MavenCoordinates>(coordinates));
    }

    @Override
    public Iterator<MavenCoordinates> iterator() {
        return this.coordinates.iterator();
    }

    public void store(Path file) throws IOException {
        Objects.requireNonNull(file, "file");
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (MavenCoordinates coords : this.coordinates) {
                writer.append(coords.toString()).append('\n');
            }
        }
        logger.info("Created artifact inventory: {}", (Object)file);
    }

    public static ArtifactInventory load(Path file) throws IOException {
        Objects.requireNonNull(file, "file");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("File doesn't exist: " + file);
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            ArtifactInventory artifactInventory = new ArtifactInventory(reader.lines().filter(StringUtils::isNotBlank).map(MavenCoordinates::parse).collect(Collectors.toSet()));
            return artifactInventory;
        }
    }

    public static ArtifactInventory create(Path directory) throws IOException {
        Objects.requireNonNull(directory, "directory");
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Directory doesn't exist: " + directory);
        }
        List jarFiles = Files.walk(directory, 1, new FileVisitOption[0]).filter(MavenJarUtils::isJARFile).collect(Collectors.toList());
        HashSet<MavenCoordinates> coordinates = new HashSet<MavenCoordinates>();
        for (Path jarFile : jarFiles) {
            Optional<MavenCoordinates> coords = MavenJarUtils.getCoordinates(jarFile);
            if (coords.isPresent()) {
                coordinates.add(coords.get());
                continue;
            }
            logger.debug("No Maven coordinates for JAR file: {}", (Object)jarFile);
        }
        return new ArtifactInventory(coordinates);
    }
}

